/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.faktorips.codegen.BaseDatatypeHelper;
import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.ConversionCodeGenerator;
import org.faktorips.datatype.AnyDatatype;
import org.faktorips.datatype.ConversionMatrix;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.datatype.util.LocalizedStringsSet;
import org.faktorips.fl.AbstractCompilationResult;
import org.faktorips.fl.BinaryOperation;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.DatatypeHelperProvider;
import org.faktorips.fl.FlFunction;
import org.faktorips.fl.FunctionResolver;
import org.faktorips.fl.IdentifierResolver;
import org.faktorips.fl.ParseTreeVisitor;
import org.faktorips.fl.UnaryOperation;
import org.faktorips.fl.parser.FlParser;
import org.faktorips.fl.parser.FlParserTokenManager;
import org.faktorips.fl.parser.JavaCharStream;
import org.faktorips.fl.parser.ParseException;
import org.faktorips.fl.parser.SimpleNode;
import org.faktorips.fl.parser.Token;
import org.faktorips.fl.parser.TokenMgrError;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;

public abstract class ExprCompiler<T extends CodeFragment> {
    public static final String PREFIX = "FLC-";
    public static final String INTERNAL_ERROR = "FLC-InternalError";
    public static final String SYNTAX_ERROR = "FLC-SyntaxError";
    public static final String DATATYPE_CREATION_ERROR = "FLC-DatatypeCreationError";
    public static final String LEXICAL_ERROR = "FLC-LexicalError";
    public static final String UNDEFINED_OPERATOR = "FLC-UndefinedOperator";
    public static final String UNDEFINED_IDENTIFIER = "FLC-UndefinedIdentifier";
    public static final String UNKNOWN_QUALIFIER = "FLC-UnknownQualifier";
    public static final String NO_ASSOCIATION_TARGET = "FLC-NoAssociationTarget";
    public static final String NO_INDEX_FOR_1TO1_ASSOCIATION = "FLC-NoIndexFor1to1Association";
    public static final String UNDEFINED_FUNCTION = "FLC-UndefinedFunction";
    public static final String WRONG_ARGUMENT_TYPES = "FLC-WrongArgumentTypes";
    public static final String WRONG_MONEY_LITERAL = "FLC-Money";
    public static final String AMBIGUOUS_FUNCTION_CALL = "FLC-AmbiguousFunctionCall";
    public static final String NULL_NOT_ALLOWED = "FLC-NullNotAllowed";
    private static final LocalizedStringsSet LOCALIZED_STRINGS = new LocalizedStringsSet("org.faktorips.fl.Messages", ExprCompiler.class.getClassLoader());
    private Locale locale;
    private IdentifierResolver<T> identifierResolver;
    private List<FunctionResolver<T>> functionResolvers = new ArrayList<FunctionResolver<T>>(2);
    private ConversionCodeGenerator<T> conversionCg;
    private Map<String, List<BinaryOperation<T>>> binaryOperations = new HashMap<String, List<BinaryOperation<T>>>();
    private Map<String, List<UnaryOperation<T>>> unaryOperations = new HashMap<String, List<UnaryOperation<T>>>();
    private FlParser parser;
    private boolean ensureResultIsObject = true;
    private DatatypeHelperProvider<T> datatypeHelperProvider;

    public ExprCompiler() {
        this(Locale.getDefault());
    }

    public ExprCompiler(Locale locale) {
        this.locale = locale;
        this.parser = new FlParser(new ByteArrayInputStream("".getBytes()));
        this.registerDefaults();
    }

    public ExprCompiler(Locale locale, IdentifierResolver<T> identifierResolver, ConversionCodeGenerator<T> conversionCg, DatatypeHelperProvider<T> datatypeHelperProvider) {
        this(locale);
        this.identifierResolver = identifierResolver;
        this.conversionCg = conversionCg;
        this.datatypeHelperProvider = datatypeHelperProvider;
    }

    public static final boolean isValidIdentifier(String identifier) {
        JavaCharStream s = new JavaCharStream(new StringReader(identifier));
        FlParserTokenManager manager = new FlParserTokenManager(s);
        Token token = manager.getNextToken();
        return token.kind == 15 && manager.getNextToken().kind == 0;
    }

    protected abstract void registerDefaults();

    public void register(BinaryOperation<T> op) {
        List operatorOperations = this.binaryOperations.computeIfAbsent(op.getOperator(), $ -> new ArrayList(20));
        operatorOperations.add(op);
        op.setCompiler(this);
    }

    public void register(UnaryOperation<T> op) {
        List operatorOperations = this.unaryOperations.computeIfAbsent(op.getOperator(), $ -> new ArrayList(20));
        operatorOperations.add(op);
    }

    public void setBinaryOperations(BinaryOperation<T>[] operations) {
        ArgumentCheck.notNull((Object[])operations);
        this.binaryOperations = new HashMap<String, List<BinaryOperation<T>>>();
        for (BinaryOperation<T> operation : operations) {
            this.register(operation);
        }
    }

    public void setUnaryOperations(UnaryOperation<T>[] operations) {
        ArgumentCheck.notNull((Object[])operations);
        this.unaryOperations = new HashMap<String, List<UnaryOperation<T>>>();
        for (UnaryOperation<T> operation : operations) {
            this.register(operation);
        }
    }

    public boolean getEnsureResultIsObject() {
        return this.ensureResultIsObject;
    }

    public void setEnsureResultIsObject(boolean newValue) {
        this.ensureResultIsObject = newValue;
    }

    public IdentifierResolver<T> getIdentifierResolver() {
        return this.identifierResolver;
    }

    public void setIdentifierResolver(IdentifierResolver<T> resolver) {
        ArgumentCheck.notNull(resolver);
        this.identifierResolver = resolver;
    }

    public ConversionCodeGenerator<T> getConversionCodeGenerator() {
        return this.conversionCg;
    }

    public void setConversionCodeGenerator(ConversionCodeGenerator<T> ccg) {
        ArgumentCheck.notNull(ccg);
        this.conversionCg = ccg;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        this.locale = locale;
    }

    public void add(FunctionResolver<T> fctResolver) {
        FlFunction<T>[] functions;
        ArgumentCheck.notNull(fctResolver);
        this.functionResolvers.add(fctResolver);
        for (FlFunction<T> function : functions = fctResolver.getFunctions()) {
            function.setCompiler(this);
        }
    }

    public void remove(FunctionResolver<T> fctResolver) {
        ArgumentCheck.notNull(fctResolver);
        this.functionResolvers.remove(fctResolver);
    }

    public FlFunction<T>[] getFunctions() {
        ArrayList<FlFunction<T>> functions = new ArrayList<FlFunction<T>>();
        for (FunctionResolver<T> resolver : this.functionResolvers) {
            FlFunction<T>[] resolverFunctions = resolver.getFunctions();
            List<FlFunction<T>> functionsOfResolver = Arrays.asList(resolverFunctions);
            Collections.sort(functionsOfResolver, new FunctionComparator());
            functions.addAll(functionsOfResolver);
        }
        FlFunction[] flFunctions = new FlFunction[functions.size()];
        return functions.toArray(flFunctions);
    }

    public LinkedHashSet<FlFunction<T>> getAmbiguousFunctions(FlFunction<T>[] functions) {
        LinkedHashSet<FlFunction<T>> ambiguousFunctions = new LinkedHashSet<FlFunction<T>>();
        for (int i = 0; i < functions.length; ++i) {
            FlFunction<T> flFunction = functions[i];
            for (int j = i + 1; j < functions.length; ++j) {
                FlFunction<T> comparedFlFunction = functions[j];
                if (!flFunction.isSame(comparedFlFunction)) continue;
                ambiguousFunctions.add(comparedFlFunction);
                ambiguousFunctions.add(flFunction);
            }
        }
        return ambiguousFunctions;
    }

    public CompilationResult<T> compile(String expr) {
        AbstractCompilationResult result;
        SimpleNode rootNode;
        try {
            rootNode = this.parse(expr);
        }
        catch (ParseException pe) {
            return this.parseExceptionToResult(pe);
        }
        catch (Exception pe) {
            pe.printStackTrace();
            return this.newCompilationResultImpl(Message.newError((String)INTERNAL_ERROR, (String)LOCALIZED_STRINGS.getString(INTERNAL_ERROR, this.getLocale())));
        }
        catch (TokenMgrError e) {
            String text = LOCALIZED_STRINGS.getString(LEXICAL_ERROR, this.getLocale(), new Object[]{e.getMessage()});
            return this.newCompilationResultImpl(Message.newError((String)LEXICAL_ERROR, (String)text));
        }
        try {
            AbstractCompilationResult compilationResult;
            ParseTreeVisitor<T> visitor = this.newParseTreeVisitor();
            result = compilationResult = (AbstractCompilationResult)rootNode.jjtAccept(visitor, null);
        }
        catch (Exception pe) {
            pe.printStackTrace();
            return this.newCompilationResultImpl(Message.newError((String)INTERNAL_ERROR, (String)LOCALIZED_STRINGS.getString(INTERNAL_ERROR, this.getLocale())));
        }
        if (result.failed()) {
            return result;
        }
        try {
            Datatype resultType = result.getDatatype();
            if (!this.getEnsureResultIsObject() || !resultType.isPrimitive()) {
                return result;
            }
            Object converted = this.convertPrimitiveToWrapper(resultType, result.getCodeFragment());
            return this.newCompilationResultImpl(converted, (Datatype)((ValueDatatype)resultType).getWrapperType());
        }
        catch (RuntimeException pe) {
            pe.printStackTrace();
            return this.newCompilationResultImpl(Message.newError((String)INTERNAL_ERROR, (String)LOCALIZED_STRINGS.getString(INTERNAL_ERROR, this.getLocale())));
        }
    }

    protected abstract T convertPrimitiveToWrapper(Datatype var1, T var2);

    protected abstract ParseTreeVisitor<T> newParseTreeVisitor();

    protected abstract AbstractCompilationResult<T> newCompilationResultImpl(Message var1);

    protected abstract AbstractCompilationResult<T> newCompilationResultImpl(T var1, Datatype var2);

    protected SimpleNode parse(String expr) throws ParseException {
        this.parser.ReInit(new StringReader(expr));
        return this.parser.start();
    }

    protected CompilationResult<T> parseExceptionToResult(ParseException e) {
        Object expected = "";
        for (int[] expectedTokenSequence : e.expectedTokenSequences) {
            expected = (String)expected + e.tokenImage[expectedTokenSequence[0]] + " ";
        }
        Object[] replacements = new Object[]{e.currentToken.next.toString(), e.currentToken.next.beginLine, e.currentToken.next.beginColumn, expected};
        return this.newCompilationResultImpl(Message.newError((String)SYNTAX_ERROR, (String)LOCALIZED_STRINGS.getString(SYNTAX_ERROR, this.getLocale(), replacements)));
    }

    BinaryOperation<T>[] getBinaryOperations(String operator) {
        List<BinaryOperation<BinaryOperation>> operatorOperations = this.binaryOperations.get(operator);
        if (operatorOperations == null) {
            return this.newBinaryOperation();
        }
        BinaryOperation[] binaryOperationsArray = new BinaryOperation[operatorOperations.size()];
        return operatorOperations.toArray(binaryOperationsArray);
    }

    private BinaryOperation<T>[] newBinaryOperation() {
        return new BinaryOperation[0];
    }

    UnaryOperation<T>[] getUnaryOperations(String operator) {
        List<UnaryOperation<UnaryOperation>> operatorOperations = this.unaryOperations.get(operator);
        if (operatorOperations == null) {
            return this.newUnaryOperation();
        }
        UnaryOperation[] unaryOperationsArray = new UnaryOperation[operatorOperations.size()];
        return operatorOperations.toArray(unaryOperationsArray);
    }

    private UnaryOperation<T>[] newUnaryOperation() {
        return new UnaryOperation[0];
    }

    public DatatypeHelperProvider<T> getDatatypeHelperProvider() {
        return this.datatypeHelperProvider;
    }

    public void setDatatypeHelperProvider(DatatypeHelperProvider<T> provider) {
        this.datatypeHelperProvider = provider;
    }

    public BaseDatatypeHelper<T> getDatatypeHelper(Datatype type) {
        if (this.datatypeHelperProvider == null || type == null) {
            return null;
        }
        return this.datatypeHelperProvider.getDatatypeHelper(type);
    }

    public static LocalizedStringsSet getLocalizedStrings() {
        return LOCALIZED_STRINGS;
    }

    public CompilationResult<T> getMatchingFunctionUsingConversion(CompilationResult<T>[] argResults, Datatype[] argTypes, String fctName) {
        FlFunction<T> function = null;
        boolean functionFoundByName = false;
        FlFunction<T>[] functions = this.getFunctions();
        LinkedHashSet<FlFunction<T>> ambiguousFunctions = this.getAmbiguousFunctions(functions);
        for (FlFunction<T> function2 : functions) {
            if (function2.match(fctName, argTypes)) {
                if (ambiguousFunctions.contains(function2)) {
                    return this.createAmbiguousFunctionCompilationResultImpl(function2);
                }
                return function2.compile(argResults);
            }
            if (function2.matchUsingConversion(fctName, argTypes, (ConversionMatrix)this.getConversionCodeGenerator())) {
                function = function2;
                continue;
            }
            if (functionFoundByName || !function2.getName().equals(fctName)) continue;
            functionFoundByName = true;
        }
        if (function != null) {
            if (ambiguousFunctions.contains(function)) {
                return this.createAmbiguousFunctionCompilationResultImpl(function);
            }
            return function.compile(this.convert(function, argResults));
        }
        return this.createErrorCompilationResult(argResults, fctName, functionFoundByName);
    }

    public CompilationResult<T> getMatchingFunctionUsingConversionSingleArgument(AbstractCompilationResult<T> argResult, Datatype argTypes, String fctName) {
        AbstractCompilationResult[] argResults = new AbstractCompilationResult[]{argResult};
        return this.getMatchingFunctionUsingConversion(argResults, new Datatype[]{argTypes}, fctName);
    }

    private CompilationResult<T> createErrorCompilationResult(CompilationResult<T>[] argResults, String fctName, boolean functionFoundByName) {
        if (functionFoundByName) {
            Object[] replacements = new String[]{fctName, this.argTypesToString(argResults)};
            String text = ExprCompiler.getLocalizedStrings().getString(WRONG_ARGUMENT_TYPES, this.getLocale(), replacements);
            return this.newCompilationResultImpl(Message.newError((String)WRONG_ARGUMENT_TYPES, (String)text));
        }
        String text = ExprCompiler.getLocalizedStrings().getString(UNDEFINED_FUNCTION, this.getLocale(), new Object[]{fctName});
        return this.newCompilationResultImpl(Message.newError((String)UNDEFINED_FUNCTION, (String)text));
    }

    private AbstractCompilationResult<T> createAmbiguousFunctionCompilationResultImpl(FlFunction<T> flFunction) {
        String text = ExprCompiler.getLocalizedStrings().getString(AMBIGUOUS_FUNCTION_CALL, this.getLocale(), new Object[]{flFunction.getName()});
        return this.newCompilationResultImpl(Message.newError((String)AMBIGUOUS_FUNCTION_CALL, (String)text));
    }

    private String argTypesToString(CompilationResult<T>[] results) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < results.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(results[i].getDatatype().getName());
        }
        return sb.toString();
    }

    private CompilationResult<T>[] convert(FlFunction<T> flFunction, CompilationResult<T>[] argResults) {
        ConversionCodeGenerator<T> conversionCodeGenerator = this.getConversionCodeGenerator();
        AbstractCompilationResult[] convertedArgs = new AbstractCompilationResult[argResults.length];
        for (int i = 0; i < argResults.length; ++i) {
            Datatype functionDatatype;
            Datatype datatype = functionDatatype = flFunction.hasVarArgs() ? flFunction.getArgTypes()[0] : flFunction.getArgTypes()[i];
            if (functionDatatype instanceof AnyDatatype) {
                convertedArgs[i] = (AbstractCompilationResult)argResults[i];
                continue;
            }
            CodeFragment fragment = conversionCodeGenerator.getConversionCode(argResults[i].getDatatype(), functionDatatype, argResults[i].getCodeFragment());
            convertedArgs[i] = this.newCompilationResultImpl(fragment, functionDatatype);
            convertedArgs[i].addMessages(argResults[i].getMessages());
        }
        return convertedArgs;
    }

    public CompilationResult<T> getBinaryOperation(String operator, AbstractCompilationResult<T> lhsResult, AbstractCompilationResult<T> rhsResult) {
        BinaryOperation<T>[] operations;
        BinaryOperation<T> operation = null;
        for (BinaryOperation<T> operation2 : operations = this.getBinaryOperations(operator)) {
            if (operation2.getLhsDatatype().equals(lhsResult.getDatatype()) && operation2.getRhsDatatype().equals(rhsResult.getDatatype())) {
                return operation2.generate(lhsResult, rhsResult);
            }
            if (!this.isConversionPossibleAndOperationIsNull(lhsResult, rhsResult, operation, operation2)) continue;
            operation = operation2;
        }
        if (operation != null) {
            AbstractCompilationResult<Object> convertedLhsResult = lhsResult;
            if (!lhsResult.getDatatype().equals(operation.getLhsDatatype()) && !(operation.getLhsDatatype() instanceof AnyDatatype)) {
                CodeFragment convertedLhs = this.getConversionCodeGenerator().getConversionCode(lhsResult.getDatatype(), operation.getLhsDatatype(), lhsResult.getCodeFragment());
                convertedLhsResult = this.newCompilationResultImpl(convertedLhs, operation.getLhsDatatype());
                convertedLhsResult.addMessages(lhsResult.getMessages());
            }
            AbstractCompilationResult<Object> convertedRhsResult = rhsResult;
            if (!rhsResult.getDatatype().equals(operation.getRhsDatatype()) && !(operation.getRhsDatatype() instanceof AnyDatatype)) {
                CodeFragment convertedRhs = this.getConversionCodeGenerator().getConversionCode(rhsResult.getDatatype(), operation.getRhsDatatype(), rhsResult.getCodeFragment());
                convertedRhsResult = this.newCompilationResultImpl(convertedRhs, operation.getRhsDatatype());
                convertedRhsResult.addMessages(rhsResult.getMessages());
            }
            return operation.generate(convertedLhsResult, convertedRhsResult);
        }
        Object[] replacements = new Object[]{operator, lhsResult.getDatatype().getName() + ", " + rhsResult.getDatatype().getName()};
        String text = ExprCompiler.getLocalizedStrings().getString(UNDEFINED_OPERATOR, this.getLocale(), replacements);
        return this.newCompilationResultImpl(Message.newError((String)UNDEFINED_OPERATOR, (String)text));
    }

    private boolean isConversionPossibleAndOperationIsNull(AbstractCompilationResult<T> lhsResult, AbstractCompilationResult<T> rhsResult, BinaryOperation<T> operation, BinaryOperation<T> operation2) {
        return operation == null && this.getConversionCodeGenerator().canConvert(lhsResult.getDatatype(), operation2.getLhsDatatype()) && this.getConversionCodeGenerator().canConvert(rhsResult.getDatatype(), operation2.getRhsDatatype());
    }

    private static class FunctionComparator
    implements Comparator<FlFunction<?>>,
    Serializable {
        private static final long serialVersionUID = -6448576956808509752L;

        private FunctionComparator() {
        }

        @Override
        public int compare(FlFunction<?> o1, FlFunction<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

