/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl;

import java.util.Objects;
import org.faktorips.datatype.AbstractDatatype;
import org.faktorips.datatype.ConversionMatrix;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.FunctionSignature;
import org.faktorips.fl.FunctionSignatures;

public class FunctionSignatureImpl
implements FunctionSignature {
    private String name;
    private Datatype type;
    private Datatype[] argTypes;
    private boolean hasVarArgs;

    public FunctionSignatureImpl(String name, FunctionSignatures signature) {
        this.name = name;
        this.type = signature.getType();
        this.argTypes = signature.getArgTypes();
        this.hasVarArgs = signature.hasVarArgs();
    }

    public FunctionSignatureImpl(String name, Datatype type, Datatype[] argTypes) {
        this.name = name;
        this.type = type;
        this.argTypes = argTypes;
        this.hasVarArgs = false;
    }

    public FunctionSignatureImpl(String name, Datatype type, Datatype argType) {
        this.name = name;
        this.type = type;
        this.argTypes = new Datatype[]{argType};
        this.hasVarArgs = true;
    }

    @Override
    public Datatype getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Datatype[] getArgTypes() {
        return this.argTypes;
    }

    @Override
    public boolean match(String name, Datatype[] otherArgTypes) {
        if (!this.name.equals(name)) {
            return false;
        }
        if (this.hasVarArgs()) {
            return this.getArgTypes()[0].equals(otherArgTypes[0]);
        }
        if (this.argTypes.length != otherArgTypes.length) {
            return false;
        }
        for (int i = 0; i < otherArgTypes.length; ++i) {
            if (this.matchDatatype(this.argTypes[i], otherArgTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchDatatype(Datatype functionDataType, Datatype expressionDataType) {
        if (Objects.equals(functionDataType, expressionDataType)) {
            return true;
        }
        if (expressionDataType instanceof AbstractDatatype) {
            AbstractDatatype abstractDatatype = (AbstractDatatype)expressionDataType;
            return abstractDatatype.matchDatatype(functionDataType);
        }
        return false;
    }

    @Override
    public boolean matchUsingConversion(String name, Datatype[] otherArgTypes, ConversionMatrix matrix) {
        if (!this.name.equals(name)) {
            return false;
        }
        if (this.hasVarArgs()) {
            for (Datatype otherArgType : otherArgTypes) {
                if (matrix.canConvert(otherArgType, this.argTypes[0])) continue;
                return false;
            }
            return true;
        }
        if (this.argTypes.length != otherArgTypes.length) {
            return false;
        }
        for (int i = 0; i < otherArgTypes.length; ++i) {
            if (matrix.canConvert(otherArgTypes[i], this.argTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSame(FunctionSignature fctSignature) {
        if (!this.name.equals(fctSignature.getName()) || !this.match(fctSignature.getName(), fctSignature.getArgTypes())) {
            return false;
        }
        return this.type.equals(fctSignature.getType());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type.getName());
        builder.append(' ');
        builder.append(this.name);
        builder.append('(');
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.argTypes[i].getName());
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public boolean hasVarArgs() {
        return this.hasVarArgs;
    }
}

