/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl;

import java.util.Arrays;
import org.faktorips.datatype.AnyDatatype;
import org.faktorips.datatype.Datatype;

public enum Operation {
    PlusDecimal("+", new Datatype[]{Datatype.DECIMAL}),
    PlusPrimitiveInt("+", new Datatype[]{Datatype.PRIMITIVE_INT}),
    PlusInteger("+", new Datatype[]{Datatype.INTEGER}),
    PlusMoney("+", new Datatype[]{Datatype.MONEY}),
    MinusDecimal("-", new Datatype[]{Datatype.DECIMAL}),
    MinusInteger("-", new Datatype[]{Datatype.INTEGER}),
    MinusPrimitiveInt("-", new Datatype[]{Datatype.PRIMITIVE_INT}),
    MinusMoney("-", new Datatype[]{Datatype.MONEY}),
    AddIntInt((Datatype)Datatype.PRIMITIVE_INT, "+", (Datatype)Datatype.PRIMITIVE_INT),
    AddDecimalInt((Datatype)Datatype.DECIMAL, "+", (Datatype)Datatype.PRIMITIVE_INT),
    AddIntDecimal((Datatype)Datatype.PRIMITIVE_INT, "+", (Datatype)Datatype.DECIMAL),
    AddDecimalInteger((Datatype)Datatype.DECIMAL, "+", (Datatype)Datatype.INTEGER),
    AddIntegerDecimal((Datatype)Datatype.INTEGER, "+", (Datatype)Datatype.DECIMAL),
    AddDecimalDecimal((Datatype)Datatype.DECIMAL, "+", (Datatype)Datatype.DECIMAL),
    AddMoneyMoney((Datatype)Datatype.MONEY, "+", (Datatype)Datatype.MONEY),
    AddStringString((Datatype)Datatype.STRING, "+", (Datatype)Datatype.STRING),
    SubtractIntInt((Datatype)Datatype.PRIMITIVE_INT, "-", (Datatype)Datatype.PRIMITIVE_INT),
    SubtractDecimalDecimal((Datatype)Datatype.DECIMAL, "-", (Datatype)Datatype.DECIMAL),
    SubtractMoneyMoney((Datatype)Datatype.MONEY, "-", (Datatype)Datatype.MONEY),
    MultiplyIntInt((Datatype)Datatype.PRIMITIVE_INT, "*", (Datatype)Datatype.PRIMITIVE_INT),
    MultiplyDecimalMoney((Datatype)Datatype.DECIMAL, "*", (Datatype)Datatype.MONEY),
    MultiplyMoneyDecimal((Datatype)Datatype.MONEY, "*", (Datatype)Datatype.DECIMAL),
    MultiplyIntegerMoney((Datatype)Datatype.INTEGER, "*", (Datatype)Datatype.MONEY),
    MultiplyDecimalDecimal((Datatype)Datatype.DECIMAL, "*", (Datatype)Datatype.DECIMAL),
    DivideDecimalDecimal((Datatype)Datatype.DECIMAL, "/", (Datatype)Datatype.DECIMAL),
    DivideMoneyDecimal((Datatype)Datatype.MONEY, "/", (Datatype)Datatype.DECIMAL),
    GreaterThanDecimalDecimal((Datatype)Datatype.DECIMAL, ">", (Datatype)Datatype.DECIMAL),
    GreaterThanMoneyMoney((Datatype)Datatype.MONEY, ">", (Datatype)Datatype.MONEY),
    GreaterThanOrEqualDecimalDecimal((Datatype)Datatype.DECIMAL, ">=", (Datatype)Datatype.DECIMAL),
    GreaterThanOrEqualMoneyMoney((Datatype)Datatype.MONEY, ">=", (Datatype)Datatype.MONEY),
    LessThanDecimalDecimal((Datatype)Datatype.DECIMAL, "<", (Datatype)Datatype.DECIMAL),
    LessThanMoneyMoney((Datatype)Datatype.MONEY, "<", (Datatype)Datatype.MONEY),
    LessThanOrEqualDecimalDecimal((Datatype)Datatype.DECIMAL, "<=", (Datatype)Datatype.DECIMAL),
    LessThanOrEqualMoneyMoney((Datatype)Datatype.MONEY, "<=", (Datatype)Datatype.MONEY),
    EqualsPrimtiveInt((Datatype)Datatype.PRIMITIVE_INT, "=", (Datatype)Datatype.PRIMITIVE_INT),
    EqualsPrimtiveBoolean((Datatype)Datatype.PRIMITIVE_BOOLEAN, "=", (Datatype)Datatype.PRIMITIVE_BOOLEAN),
    EqualsDecimal((Datatype)Datatype.DECIMAL, "=", (Datatype)Datatype.DECIMAL),
    EqualsMoney((Datatype)Datatype.MONEY, "=", (Datatype)Datatype.MONEY),
    EqualsString((Datatype)Datatype.STRING, "=", (Datatype)Datatype.STRING),
    EqualsInstance((Datatype)AnyDatatype.INSTANCE, "=", (Datatype)AnyDatatype.INSTANCE),
    NotEqualsDecimal((Datatype)Datatype.DECIMAL, "!=", (Datatype)Datatype.DECIMAL),
    NotEqualsMoney((Datatype)Datatype.MONEY, "!=", (Datatype)Datatype.MONEY),
    ParenthesisInt("()", new Datatype[]{Datatype.PRIMITIVE_INT}),
    ParenthesisDecimal("()", new Datatype[]{Datatype.DECIMAL}),
    ParenthesisMoney("()", new Datatype[]{Datatype.MONEY}),
    ParenthesisString("()", new Datatype[]{Datatype.STRING});

    private final String operator;
    private final Datatype[] operands;

    private Operation(String operator, Datatype ... operands) {
        this.operator = operator;
        this.operands = operands;
    }

    private Operation(Datatype lhs, String operator, Datatype rhs) {
        this(operator, lhs, rhs);
    }

    public String getOperator() {
        return this.operator;
    }

    public Datatype getOperand() {
        if (this.operands.length != 1) {
            throw new IllegalStateException("The operation " + this.toString() + " is not a unary operation.");
        }
        return this.operands[0];
    }

    public Datatype getLhs() {
        if (this.operands.length != 2) {
            throw new IllegalStateException("The operation " + this.toString() + " is not a binary operation.");
        }
        return this.operands[0];
    }

    public Datatype getRhs() {
        if (this.operands.length != 2) {
            throw new IllegalStateException("The operation " + this.toString() + " is not a binary operation.");
        }
        return this.operands[1];
    }

    public String toString() {
        return "\"" + this.operator + "\" " + Arrays.toString(this.operands);
    }
}

