/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions;

import java.math.RoundingMode;
import java.util.Objects;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.util.ArgumentCheck;

public class Round
extends AbstractFlFunction {
    private RoundingMode roundingMode;

    public Round(String name, String description, RoundingMode roundingMode) {
        super(name, description, Round.getSignature(Objects.requireNonNull(roundingMode, "roundingMode cannot be null")));
        this.roundingMode = roundingMode;
    }

    @Deprecated
    public Round(String name, String description, int roundingMode) {
        this(name, description, RoundingMode.valueOf(roundingMode));
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)2);
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append(argResults[0].getCodeFragment());
        fragment.append(".setScale(");
        fragment.append(argResults[1].getCodeFragment());
        fragment.append(", ");
        fragment.appendClassName(RoundingMode.class);
        fragment.append('.');
        fragment.append(this.roundingMode.name());
        fragment.append(')');
        return new CompilationResultImpl(fragment, (Datatype)Datatype.DECIMAL);
    }

    private static FunctionSignatures getSignature(RoundingMode mode) {
        return switch (mode) {
            case RoundingMode.DOWN -> FunctionSignatures.RoundDown;
            case RoundingMode.UP -> FunctionSignatures.RoundUp;
            default -> FunctionSignatures.Round;
        };
    }
}

