/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.operations;

import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.ConversionCodeGenerator;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.functions.Messages;
import org.faktorips.fl.operations.AbstractBinaryJavaOperation;
import org.faktorips.runtime.Message;
import org.faktorips.values.ObjectUtil;

public class EqualsObjectDatatype
extends AbstractBinaryJavaOperation {
    protected EqualsObjectDatatype(String operator, Datatype lhsDatatype, Datatype rhsDatatype) {
        super(operator, lhsDatatype, rhsDatatype);
    }

    public EqualsObjectDatatype(Datatype lhsDatatype, Datatype rhsDatatype) {
        super("=", lhsDatatype, rhsDatatype);
    }

    public EqualsObjectDatatype(Datatype type) {
        super("=", type, type);
    }

    protected static String getErrorMessageCode() {
        return "FLC-EQUALS-OPERATION";
    }

    @Override
    public CompilationResultImpl generate(CompilationResultImpl lhs, CompilationResultImpl rhs) {
        ConversionCodeGenerator ccg = this.getCompiler().getConversionCodeGenerator();
        Datatype datatype1 = lhs.getDatatype();
        Datatype datatype2 = rhs.getDatatype();
        CompilationResultImpl left = lhs;
        CompilationResultImpl right = rhs;
        if (!datatype1.equals(datatype2)) {
            if (ccg.canConvert(datatype1, datatype2)) {
                converted = (JavaCodeFragment)ccg.getConversionCode(datatype1, datatype2, (CodeFragment)((JavaCodeFragment)lhs.getCodeFragment()));
                left = newResult = new CompilationResultImpl(converted, datatype2, lhs.getMessages());
            } else if (ccg.canConvert(datatype2, datatype1)) {
                converted = (JavaCodeFragment)ccg.getConversionCode(datatype2, datatype1, (CodeFragment)((JavaCodeFragment)rhs.getCodeFragment()));
                right = newResult = new CompilationResultImpl(converted, datatype1, rhs.getMessages());
            } else {
                String text = Messages.INSTANCE.getString(EqualsObjectDatatype.getErrorMessageCode(), new Object[]{datatype1, datatype2});
                Message msg = Message.newError((String)EqualsObjectDatatype.getErrorMessageCode(), (String)text);
                return new CompilationResultImpl(msg);
            }
        }
        CompilationResultImpl result = new CompilationResultImpl();
        result.setDatatype((Datatype)Datatype.PRIMITIVE_BOOLEAN);
        JavaCodeFragment frag = (JavaCodeFragment)result.getCodeFragment();
        frag.appendClassName(ObjectUtil.class);
        frag.append(".equals(");
        frag.append((JavaCodeFragment)right.getCodeFragment());
        frag.append(", ");
        frag.append((JavaCodeFragment)left.getCodeFragment());
        frag.append(')');
        return result;
    }
}

