/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.parser;

import org.faktorips.fl.parser.FlParser;
import org.faktorips.fl.parser.FlParserTreeConstants;
import org.faktorips.fl.parser.FlParserVisitor;
import org.faktorips.fl.parser.Node;
import org.faktorips.fl.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected FlParser parser;
    private Token firstToken;
    private Token lastToken;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(FlParser p, int i) {
        this(i);
        this.parser = p;
    }

    public Token getFirstToken() {
        return this.firstToken;
    }

    public Token getLastToken() {
        return this.lastToken;
    }

    @Override
    public void jjtOpen() {
        this.firstToken = this.parser.getToken(1);
    }

    @Override
    public void jjtClose() {
        this.lastToken = this.parser.getToken(0);
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(FlParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(FlParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (Node element : this.children) {
                element.jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return FlParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (Node element : this.children) {
                SimpleNode n = (SimpleNode)element;
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }
}

