/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.fl.functions.date;

import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.ILocalDateHelper;
import org.faktorips.datatype.Datatype;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.fl.FunctionSignatures;
import org.faktorips.fl.functions.AbstractFlFunction;
import org.faktorips.fl.functions.Messages;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;

public class Date
extends AbstractFlFunction {
    public Date(String name, String description) {
        super(name, description, FunctionSignatures.DATE);
    }

    @Override
    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        ArgumentCheck.length((Object[])argResults, (int)3);
        JavaCodeFragment year = argResults[0].getCodeFragment();
        JavaCodeFragment month = argResults[1].getCodeFragment();
        JavaCodeFragment day = argResults[2].getCodeFragment();
        Datatype datatype = this.getType();
        DatatypeHelper datatypeHelper = this.getDatatypeHelper(datatype);
        if (datatypeHelper instanceof ILocalDateHelper) {
            JavaCodeFragment fragment = ((ILocalDateHelper)datatypeHelper).getDateInitialization(year, month, day);
            return new CompilationResultImpl(fragment, datatype);
        }
        String code = "FLC-NO_PERIOD_SUPPORT";
        String text = Messages.INSTANCE.getString(code, new Object[]{datatype});
        Message msg = Message.newError((String)code, (String)text);
        return new CompilationResultImpl(msg);
    }
}

