/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.Table;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TableSaxHandler
extends DefaultHandler {
    private static final String VALUE = "Value";
    private static final String ROW = "Row";
    private Table<?> table;
    private List<String> columns = new ArrayList<String>(20);
    private StringBuffer textBuffer = null;
    private boolean insideRowNode;
    private boolean insideValueNode;
    private boolean nullValue;
    private IRuntimeRepository productRepository;

    public TableSaxHandler(Table<?> table, IRuntimeRepository productRepository) {
        this.table = table;
        this.productRepository = productRepository;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ROW.equals(qName)) {
            this.insideRowNode = false;
            this.table.addRow(this.columns, this.productRepository);
            this.columns.clear();
        } else if (this.isColumnValueNode(qName)) {
            this.insideValueNode = false;
            this.columns.add(this.textBuffer == null && this.nullValue ? null : (this.textBuffer == null ? new String("") : this.textBuffer.substring(0)));
            this.textBuffer = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (ROW.equals(qName)) {
            this.insideRowNode = true;
        } else if (this.isColumnValueNode(qName)) {
            this.insideValueNode = true;
            this.nullValue = Boolean.valueOf(attributes.getValue("isNull"));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (!this.insideValueNode) {
            return;
        }
        String s = new String(buf, offset, len);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    private boolean isColumnValueNode(String nodeName) {
        return VALUE.equals(nodeName) && this.insideRowNode;
    }
}

