/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.faktorips.runtime.IMarker;
import org.faktorips.runtime.MsgReplacementParameter;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.values.ObjectUtil;

public class Message
implements Serializable {
    public static final Severity NONE = Severity.NONE;
    public static final Severity INFO = Severity.INFO;
    public static final Severity WARNING = Severity.WARNING;
    public static final Severity ERROR = Severity.ERROR;
    private static final long serialVersionUID = 6538319330010542283L;
    private final Severity severity;
    private final String text;
    private final String code;
    private final List<ObjectProperty> invalidOp;
    private final List<MsgReplacementParameter> replacementParameters;
    private final Set<? extends IMarker> markers;

    public Message(Builder builder) {
        this(builder.code, builder.text, builder.severity, builder.invalidObjectProperties, builder.replacementParams, builder.markers);
    }

    public Message(Message msg) {
        this(msg.code, msg.text, msg.severity, msg.invalidOp, msg.replacementParameters, msg.markers);
    }

    public Message(String text, Severity severity) {
        this(new Builder(text, severity));
    }

    public Message(String code, String text, Severity severity) {
        this(new Builder(text, severity).code(code));
    }

    public Message(String code, String text, Severity severity, Object invalidObject) {
        this(new Builder(text, severity).code(code).invalidObjectWithProperties(invalidObject, new String[]{null}));
    }

    public Message(String code, String text, Severity severity, ObjectProperty invalidObjectProperty) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperty));
    }

    public Message(String code, String text, Severity severity, Object invalidObject, String ... invalidObjectProperties) {
        this(new Builder(text, severity).code(code).invalidObjectWithProperties(invalidObject, invalidObjectProperties));
    }

    public Message(String code, String text, Severity severity, ObjectProperty[] invalidObjectProperties) {
        this(new Builder(text, severity).code(code).invalidObjects(Arrays.asList(invalidObjectProperties)));
    }

    public Message(String code, String text, Severity severity, List<ObjectProperty> invalidObjectProperties) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperties));
    }

    public Message(String code, String text, Severity severity, List<ObjectProperty> invalidObjectProperties, List<MsgReplacementParameter> replacementParameters) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperties).replacements(replacementParameters).markers(Collections.emptySet()));
    }

    public Message(String code, String text, Severity severity, ObjectProperty invalidObjectProperty, MsgReplacementParameter ... parameters) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperty).replacements(parameters).markers(Collections.emptySet()));
    }

    public Message(String code, String text, Severity severity, ObjectProperty invalidObjectProperty, List<MsgReplacementParameter> parameters) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperty).replacements(parameters).markers(Collections.emptySet()));
    }

    public Message(String code, String text, Severity severity, ObjectProperty[] invalidObjectProperties, MsgReplacementParameter[] parameters) {
        this(new Builder(text, severity).code(code).invalidObjects(Arrays.asList(invalidObjectProperties)).replacements(parameters).markers(Collections.emptySet()));
    }

    public Message(String code, String text, Severity severity, List<ObjectProperty> invalidObjectProperties, List<MsgReplacementParameter> parameters, Set<? extends IMarker> markers) {
        this.code = code;
        this.text = text;
        this.severity = severity;
        this.markers = markers != null ? Collections.unmodifiableSet(new HashSet<IMarker>(markers)) : Collections.emptySet();
        this.invalidOp = invalidObjectProperties != null ? Collections.unmodifiableList(new ArrayList<ObjectProperty>(invalidObjectProperties)) : Collections.emptyList();
        this.replacementParameters = parameters != null ? Collections.unmodifiableList(new ArrayList<MsgReplacementParameter>(parameters)) : Collections.emptyList();
    }

    public static final Builder error(String text) {
        return new Builder(text, ERROR);
    }

    public static final Builder warning(String text) {
        return new Builder(text, WARNING);
    }

    public static final Builder info(String text) {
        return new Builder(text, INFO);
    }

    public static final Message createCopy(Message msg, Object oldObject, Object newObject) {
        List<ObjectProperty> op = msg.getInvalidObjectProperties();
        ArrayList<ObjectProperty> newOp = new ArrayList<ObjectProperty>(op.size());
        for (ObjectProperty objectProperty : op) {
            if (objectProperty.getObject() == oldObject) {
                newOp.add(new ObjectProperty(newObject, objectProperty.getProperty()));
                continue;
            }
            newOp.add(objectProperty);
        }
        return new Builder(msg.text, msg.severity).code(msg.code).invalidObjects(newOp).replacements(msg.getReplacementParameters()).markers(msg.getMarkers()).create();
    }

    public static final Message newInfo(String code, String text) {
        return new Message(code, text, INFO);
    }

    public static final Message newWarning(String code, String text) {
        return new Message(code, text, WARNING);
    }

    public static final Message newError(String code, String text) {
        return new Message(code, text, ERROR);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public String getCode() {
        return this.code;
    }

    public int getNumOfInvalidObjectProperties() {
        if (this.invalidOp == null) {
            return 0;
        }
        return this.invalidOp.size();
    }

    public List<ObjectProperty> getInvalidObjectProperties() {
        if (this.invalidOp == null) {
            return new ArrayList<ObjectProperty>(0);
        }
        return Collections.unmodifiableList(this.invalidOp);
    }

    public int getNumOfReplacementParameters() {
        if (this.replacementParameters == null) {
            return 0;
        }
        return this.replacementParameters.size();
    }

    public List<MsgReplacementParameter> getReplacementParameters() {
        if (this.replacementParameters == null) {
            return new ArrayList<MsgReplacementParameter>(0);
        }
        return this.replacementParameters;
    }

    public boolean hasReplacementParameter(String paramName) {
        if (this.replacementParameters == null) {
            return false;
        }
        for (MsgReplacementParameter replacementParameter : this.replacementParameters) {
            if (!replacementParameter.getName().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    public Object getReplacementValue(String paramName) {
        if (this.replacementParameters == null) {
            return null;
        }
        for (MsgReplacementParameter replacementParameter : this.replacementParameters) {
            if (!replacementParameter.getName().equals(paramName)) continue;
            return replacementParameter.getValue();
        }
        return null;
    }

    public Set<? extends IMarker> getMarkers() {
        return this.markers;
    }

    public boolean hasMarker(IMarker marker) {
        return this.markers.contains(marker);
    }

    public boolean hasMarkers() {
        return !this.markers.isEmpty();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        switch (this.severity) {
            case ERROR: {
                buffer.append("ERROR");
                break;
            }
            case WARNING: {
                buffer.append("WARNING ");
                break;
            }
            case INFO: {
                buffer.append("INFO");
                break;
            }
            default: {
                buffer.append("Severity ");
                buffer.append((Object)this.severity);
            }
        }
        buffer.append(' ');
        buffer.append(this.code);
        buffer.append('[');
        String lineSeparator = System.getProperty("line.separator");
        int max = this.invalidOp == null ? 0 : this.invalidOp.size();
        int i = 0;
        while (i < max) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.invalidOp.get(i).getObject().toString());
            buffer.append('.');
            buffer.append(this.invalidOp.get(i).getProperty());
            ++i;
        }
        buffer.append(']');
        buffer.append(lineSeparator);
        buffer.append(this.text);
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!ObjectUtil.equals((Object)this.code, (Object)other.code)) {
            return false;
        }
        if (!ObjectUtil.equals((Object)this.text, (Object)other.text)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (!ObjectUtil.equals(this.invalidOp, other.invalidOp)) {
            return false;
        }
        if (!ObjectUtil.equals(this.replacementParameters, other.replacementParameters)) {
            return false;
        }
        return ObjectUtil.equals(this.markers, other.markers);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public static class Builder {
        private final String text;
        private final Severity severity;
        private String code;
        private List<ObjectProperty> invalidObjectProperties;
        private List<MsgReplacementParameter> replacementParams;
        private Set<? extends IMarker> markers;

        public Builder(String text, Severity severity) {
            this.text = text;
            this.severity = severity;
        }

        public Builder(Message message) {
            this(message.text, message.severity);
            this.code = message.code;
            this.invalidObjectProperties = message.getInvalidObjectProperties();
            this.replacementParams = message.getReplacementParameters();
            this.markers = message.getMarkers();
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder invalidObjects(List<ObjectProperty> invalidObjectProperties) {
            this.invalidObjectProperties = invalidObjectProperties;
            return this;
        }

        public Builder invalidObject(ObjectProperty invalidObjectProperty) {
            return this.invalidObjects(invalidObjectProperty);
        }

        public Builder invalidObjects(ObjectProperty ... invalidObjectProperties) {
            return this.invalidObjects(Arrays.asList(invalidObjectProperties));
        }

        public Builder invalidObjectWithProperties(Object object, String ... properties) {
            this.invalidObjectProperties = new ArrayList<ObjectProperty>();
            if (properties.length == 0) {
                this.invalidObjectProperties.add(new ObjectProperty(object));
            } else {
                String[] stringArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    String property = stringArray[n2];
                    this.invalidObjectProperties.add(new ObjectProperty(object, property));
                    ++n2;
                }
            }
            return this;
        }

        public Builder replacements(List<MsgReplacementParameter> replacementParams) {
            this.replacementParams = replacementParams;
            return this;
        }

        public Builder replacements(MsgReplacementParameter ... replacementParams) {
            this.replacementParams = Arrays.asList(replacementParams);
            return this;
        }

        public Builder replacements(String name, Object value) {
            this.replacementParams = Arrays.asList(new MsgReplacementParameter(name, value));
            return this;
        }

        public Builder markers(Collection<? extends IMarker> markers) {
            this.markers = new HashSet<IMarker>(markers);
            return this;
        }

        public Builder markers(IMarker ... markers) {
            this.markers = new HashSet<IMarker>(Arrays.asList(markers));
            return this;
        }

        public Message create() {
            return new Message(this);
        }
    }
}

