/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.beans.Expression;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IClRepositoryObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.AbstractTocBasedRuntimeRepository;
import org.faktorips.runtime.internal.EnumSaxHandler;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.internal.Table;
import org.faktorips.runtime.internal.productvariant.ProductVariantRuntimeHelper;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.faktorips.runtime.test.IpsTestCase2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.values.InternationalString;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractClassLoadingRuntimeRepository
extends AbstractTocBasedRuntimeRepository {
    private final ClassLoader cl;
    private final ProductVariantRuntimeHelper productVariantHelper = new ProductVariantRuntimeHelper();

    public AbstractClassLoadingRuntimeRepository(String name, ICacheFactory cacheFactory, ClassLoader cl) {
        super(name, cacheFactory, cl);
        this.cl = cl;
    }

    @Override
    protected IProductComponent createProductCmpt(ProductCmptTocEntry tocEntry) {
        Element prodCmptElement = this.getDocumentElement(tocEntry);
        if (!this.getProductVariantHelper().isProductVariantXML(prodCmptElement)) {
            ProductComponent productCmpt = this.createProductComponentInstance(tocEntry.getImplementationClassName(), tocEntry.getIpsObjectId(), tocEntry.getKindId(), tocEntry.getVersionId());
            productCmpt.initFromXml(prodCmptElement);
            return productCmpt;
        }
        ProductComponent originalProdCmpt = this.getProductVariantHelper().getOriginalProdCmpt(this, prodCmptElement);
        ProductComponent productCmpt = this.createProductComponentInstance(originalProdCmpt.getClass().getName(), tocEntry.getIpsObjectId(), tocEntry.getKindId(), tocEntry.getVersionId());
        this.getProductVariantHelper().initProductComponentVariation(originalProdCmpt, productCmpt, prodCmptElement);
        return productCmpt;
    }

    protected ProductComponent createProductComponentInstance(String implementationClassName, String ipsObjectId, String kindId, String versionId) {
        ProductComponent productCmpt;
        try {
            Constructor<?> constructor = this.getProductComponentConstructor(implementationClassName);
            productCmpt = (ProductComponent)constructor.newInstance(this, ipsObjectId, kindId, versionId);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't create product component instance for class name \"" + implementationClassName + "\". RuntimeId=" + ipsObjectId, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can't create product component instance for class name \"" + implementationClassName + "\". RuntimeId=" + ipsObjectId, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Can't create product component instance for class name \"" + implementationClassName + "\". RuntimeId=" + ipsObjectId, e);
        }
        return productCmpt;
    }

    private Constructor<?> getProductComponentConstructor(String implementationClassName) {
        try {
            Class<?> implClass = this.getClass(implementationClassName, this.getClassLoader());
            Class<?> runtimeRepoClass = this.getClass(IRuntimeRepository.class.getName(), this.getClassLoader());
            Constructor<?> constructor = implClass.getConstructor(runtimeRepoClass, String.class, String.class, String.class);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can't create product component instance for class name \"" + implementationClassName);
        }
    }

    @Override
    protected <T> List<T> createEnumValues(EnumContentTocEntry tocEntry, Class<T> enumClass) {
        List<List<Object>> enumValueList = this.getEnumValueListFromSaxHandler(tocEntry);
        if (enumValueList.isEmpty()) {
            return Collections.emptyList();
        }
        Constructor<T> constructor = this.getCandidateConstructorThrowRuntimeException(tocEntry, enumClass, this.getParameterSize(enumValueList));
        return this.getCreatedEnumValueList(tocEntry, enumValueList, constructor, this.getEnumValuesDefinedInType(enumClass).size());
    }

    private <T> List<T> getCreatedEnumValueList(EnumContentTocEntry tocEntry, List<List<Object>> enumValueList, Constructor<T> constructor, int startIndex) {
        Object enumValue = null;
        ArrayList<Object> enumValues = new ArrayList<Object>();
        int valueCounterForIndexParameter = startIndex;
        for (List<Object> enumValueAsStrings : enumValueList) {
            constructor.setAccessible(true);
            Object[] enumAttributeValues = enumValueAsStrings.toArray();
            Object[] parameters = new Object[enumAttributeValues.length + 2];
            this.setValuesForParamters(valueCounterForIndexParameter, enumAttributeValues, parameters);
            enumValue = this.createEnumValue(constructor, parameters, tocEntry);
            enumValues.add(enumValue);
            ++valueCounterForIndexParameter;
        }
        return enumValues;
    }

    private void setValuesForParamters(int valueCounterForIndexParameter, Object[] enumAttributeValues, Object[] parameters) {
        parameters[0] = valueCounterForIndexParameter;
        System.arraycopy(enumAttributeValues, 0, parameters, 1, enumAttributeValues.length);
        parameters[enumAttributeValues.length + 1] = this;
    }

    private int getParameterSize(List<List<Object>> enumValueList) {
        return enumValueList.get(0).size() + 2;
    }

    private <T> Constructor<T> getCandidateConstructorThrowRuntimeException(EnumContentTocEntry tocEntry, Class<T> enumClass, int parameterSize) {
        Class<?> runtimeRepoClass = this.getClass(IRuntimeRepository.class.getName(), this.getClassLoader());
        Constructor<T> constructor = this.getCorrectConstructor(parameterSize, runtimeRepoClass, enumClass);
        if (constructor == null) {
            throw new RuntimeException("No valid constructor found to create enumerations instances for the toc entry " + tocEntry);
        }
        return constructor;
    }

    private List<List<Object>> getEnumValueListFromSaxHandler(EnumContentTocEntry tocEntry) {
        EnumSaxHandler saxhandler = this.parseEnumValues(tocEntry);
        List<List<Object>> enumValueList = saxhandler.getEnumValueList();
        return enumValueList;
    }

    private EnumSaxHandler parseEnumValues(EnumContentTocEntry tocEntry) {
        InputStream is = this.getXmlAsStream(tocEntry);
        EnumSaxHandler saxhandler = new EnumSaxHandler();
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(is), (DefaultHandler)saxhandler);
        }
        catch (SAXException e) {
            throw new RuntimeException("Can't parse the enumeration content of the resource " + tocEntry.getXmlResourceName(), e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Can't parse the enumeration content of the resource " + tocEntry.getXmlResourceName(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't parse the enumeration content of the resource " + tocEntry.getXmlResourceName(), e);
        }
        return saxhandler;
    }

    private <T> Constructor<T> getCorrectConstructor(int parameterSize, Class<?> runtimeRepoClass, Class<T> enumClass) {
        Constructor<?>[] constructors = enumClass.getDeclaredConstructors();
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypes;
            Constructor<?> currentConstructor = constructorArray[n2];
            if (this.isProtected(currentConstructor) && (parameterTypes = currentConstructor.getParameterTypes()).length == parameterSize) {
                boolean correct = true;
                int i = 0;
                while (i < parameterTypes.length) {
                    Class<?> parameterClass = parameterTypes[i];
                    if (i == parameterTypes.length - 1) {
                        if (parameterClass != runtimeRepoClass) {
                            correct = false;
                            break;
                        }
                    } else if (this.isParameterClassValid(parameterClass)) {
                        correct = false;
                        break;
                    }
                    ++i;
                }
                if (correct) {
                    Constructor<?> castedConstructor;
                    constructor = castedConstructor = currentConstructor;
                    break;
                }
            }
            ++n2;
        }
        return constructor;
    }

    private boolean isParameterClassValid(Class<?> parameterClass) {
        return parameterClass != String.class && !InternationalString.class.isAssignableFrom(parameterClass) && parameterClass != Integer.TYPE;
    }

    private boolean isProtected(Constructor<?> currentConstructor) {
        return (currentConstructor.getModifiers() & 4) > 0;
    }

    private <T> T createEnumValue(Constructor<T> constructor, Object[] parameters, TocEntry tocEntry) {
        T enumValue;
        try {
            enumValue = constructor.newInstance(parameters);
        }
        catch (InstantiationException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        catch (IllegalAccessException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        catch (InvocationTargetException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        return enumValue;
    }

    @Override
    protected IProductComponentGeneration createProductCmptGeneration(GenerationTocEntry tocEntry) {
        Element genElement = this.getDocumentElement(tocEntry);
        if (!this.getProductVariantHelper().isProductVariantXML(genElement)) {
            ProductComponent productCmpt = (ProductComponent)this.getProductComponent(tocEntry.getParent().getIpsObjectId());
            if (productCmpt == null) {
                throw new RuntimeException("Can't get product component for toc entry " + tocEntry);
            }
            ProductComponentGeneration productCmptGen = this.createProductComponentGenerationInstance(tocEntry, productCmpt);
            productCmptGen.initFromXml(genElement);
            return productCmptGen;
        }
        return this.getProductVariantHelper().initProductComponentGenerationVariation(this, tocEntry, genElement);
    }

    protected ProductVariantRuntimeHelper getProductVariantHelper() {
        return this.productVariantHelper;
    }

    protected ProductComponentGeneration createProductComponentGenerationInstance(GenerationTocEntry tocEntry, ProductComponent productCmpt) {
        ProductComponentGeneration productCmptGen;
        try {
            Class<?> implClass = this.getClass(this.getProductComponentGenerationImplClass(tocEntry), this.cl);
            Expression expression = new Expression(implClass, "new", new Object[]{productCmpt});
            productCmptGen = (ProductComponentGeneration)expression.getValue();
        }
        catch (Exception e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        return productCmptGen;
    }

    private RuntimeException createCannotInstantiateException(Exception e, TocEntry tocEntry) {
        return new RuntimeException("Can't create instance for toc entry " + tocEntry, e);
    }

    @Override
    protected <T extends IProductComponent> void getAllProductComponentsInternal(Class<T> productCmptClass, List<T> result) {
        List<ProductCmptTocEntry> entries = this.getTableOfContents().getProductCmptTocEntries();
        for (ProductCmptTocEntry entry : entries) {
            Class<?> clazz = this.getClass(entry.getImplementationClassName(), this.cl);
            if (!productCmptClass.isAssignableFrom(clazz)) continue;
            IProductComponent productComponentInternal = this.getProductComponentInternal(entry.getIpsObjectId());
            result.add(productComponentInternal);
        }
    }

    @Override
    protected ITable<?> createTable(TableContentTocEntry tocEntry) {
        Table table;
        Class<?> implClass = this.getClass(tocEntry.getImplementationClassName(), this.getClassLoader());
        try {
            Constructor<?> constructor = this.getTableConstructor(implClass, tocEntry);
            table = (Table)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        catch (InstantiationException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        catch (InvocationTargetException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        InputStream is = this.getXmlAsStream(tocEntry);
        try {
            try {
                table.initFromXml(is, this, tocEntry.getIpsObjectId());
            }
            catch (Exception e) {
                throw new RuntimeException("Can't parse xml for " + tocEntry.getIpsObjectId(), e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close the input stream for : " + tocEntry.getIpsObjectId(), e);
            }
        }
        return table;
    }

    private Constructor<?> getTableConstructor(Class<?> implClass, TableContentTocEntry tocEntry) {
        Constructor<?> constructor;
        try {
            constructor = implClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        return constructor;
    }

    @Override
    protected IpsTestCaseBase createTestCase(TestCaseTocEntry tocEntry, IRuntimeRepository runtimeRepository) {
        IpsTestCaseBase test;
        try {
            Constructor<?> constructor = this.getTestCaseConstructor(tocEntry);
            test = (IpsTestCaseBase)constructor.newInstance(tocEntry.getIpsObjectQualifiedName());
        }
        catch (IllegalAccessException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        catch (InstantiationException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        catch (InvocationTargetException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        test.setRepository(runtimeRepository);
        if (test instanceof IpsTestCase2) {
            Element docElement = this.getDocumentElement(tocEntry);
            ((IpsTestCase2)test).initFromXml(docElement);
        }
        test.setFullPath(tocEntry.getIpsObjectId());
        return test;
    }

    private Constructor<?> getTestCaseConstructor(TestCaseTocEntry tocEntry) {
        try {
            Class<?> implClass = this.getClass(tocEntry.getImplementationClassName(), this.getClassLoader());
            Constructor<?> constructor = implClass.getConstructor(String.class);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    protected abstract Element getDocumentElement(ProductCmptTocEntry var1);

    protected abstract Element getDocumentElement(GenerationTocEntry var1);

    protected abstract Element getDocumentElement(TestCaseTocEntry var1);

    protected abstract String getProductComponentGenerationImplClass(GenerationTocEntry var1);

    protected abstract InputStream getXmlAsStream(EnumContentTocEntry var1);

    protected abstract InputStream getXmlAsStream(TableContentTocEntry var1);

    @Override
    protected <T> T createCustomObject(CustomTocEntryObject<T> tocEntry) {
        T runtimeObject = tocEntry.createRuntimeObject(this);
        if (runtimeObject instanceof IClRepositoryObject) {
            this.initClRepositoryObject(tocEntry, (IClRepositoryObject)runtimeObject);
        }
        return runtimeObject;
    }

    protected <T> void initClRepositoryObject(CustomTocEntryObject<T> tocEntry, IClRepositoryObject runtimeObject) {
        Element docElement = this.getDocumentElement(tocEntry);
        runtimeObject.initFromXml(docElement);
    }

    protected abstract <T> Element getDocumentElement(CustomTocEntryObject<T> var1);
}

