/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.runtime.test.IpsTestFailure;
import org.faktorips.runtime.test.IpsTestListener;
import org.faktorips.runtime.test.IpsTestResult;

public class IpsTestCaseJUnitAdapter
extends TestCase
implements IpsTestListener {
    private static final String FAILUREFORMAT_FAILUREIN = "Failure in: \"{0}\"";
    private static final String FAILUREFORMAT_OBJECT = ", Object: \"{0}\"";
    private static final String FAILUREFORMAT_ATTRIBUTE = ", Attribute: \"{0}\".";
    private static final String FAILUREFORMAT_EXPECTED = ", expected: \"{0}\"";
    private static final String FAILUREFORMAT_ACTUAL = " but was: \"{0}\"";
    private IpsTestCaseBase ipsTestCase;
    private List<IpsTestFailure> failures = new ArrayList<IpsTestFailure>();

    public IpsTestCaseJUnitAdapter(IpsTestCaseBase ipsTestCase) {
        super(ipsTestCase.getName());
        this.ipsTestCase = ipsTestCase;
    }

    public IpsTestCaseJUnitAdapter(String name) {
        super(name);
    }

    public void testNothing() {
    }

    public void runTest() throws Throwable {
        if (this.ipsTestCase == null) {
            return;
        }
        IpsTestResult ipsTestResult = new IpsTestResult();
        ipsTestResult.addListener(this);
        this.ipsTestCase.run(ipsTestResult);
        if (this.failures.size() > 0) {
            StringBuffer failureBuffer = new StringBuffer(this.failures.size() * 40);
            for (IpsTestFailure failure : this.failures) {
                if (failure.isError()) {
                    throw failure.getThrowable();
                }
                if (failureBuffer.length() > 0) {
                    failureBuffer.append(System.getProperty("line.separator"));
                }
                failureBuffer.append(this.failureToString(failure));
            }
            IpsTestCaseJUnitAdapter.fail((String)failureBuffer.toString());
        }
    }

    private String failureToString(IpsTestFailure failure) {
        StringBuilder failureMessage = new StringBuilder();
        failureMessage.append(MessageFormat.format(FAILUREFORMAT_FAILUREIN, failure.getTestCase() != null ? failure.getTestCase().getQualifiedName() : null));
        this.appendFormatted(failureMessage, FAILUREFORMAT_EXPECTED, failure.getExpectedValue());
        this.appendFormatted(failureMessage, FAILUREFORMAT_ACTUAL, failure.getActualValue());
        this.appendFormatted(failureMessage, FAILUREFORMAT_OBJECT, failure.getTestObject());
        this.appendFormatted(failureMessage, FAILUREFORMAT_ATTRIBUTE, failure.getTestedAttribute());
        return failureMessage.toString();
    }

    private void appendFormatted(StringBuilder sb, String pattern, Object value) {
        if (value != null) {
            sb.append(MessageFormat.format(pattern, value));
        }
    }

    @Override
    public void testStarted(IpsTest2 test) {
    }

    @Override
    public void testFinished(IpsTest2 arg0) {
    }

    @Override
    public void testFailureOccured(IpsTestFailure f) {
        this.failures.add(f);
    }
}

