/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.delta;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.faktorips.runtime.IDeltaComputationOptions;
import org.faktorips.runtime.IDeltaSupport;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IModelObjectDelta;
import org.faktorips.runtime.internal.ModelObjectDelta;

public class ChildDeltaCreator {
    private final String association;
    private final IDeltaComputationOptions options;

    public ChildDeltaCreator(String association, IDeltaComputationOptions options) {
        this.association = association;
        this.options = options;
    }

    public void createChildDeltas(ModelObjectDelta delta, IModelObject original, IModelObject refObject) {
        this.createChildDeltas(delta, ChildDeltaCreator.listOf(original), ChildDeltaCreator.listOf(refObject));
    }

    private static List<IModelObject> listOf(IModelObject item) {
        if (item != null) {
            return Collections.singletonList(item);
        }
        return Collections.emptyList();
    }

    public void createChildDeltas(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects) {
        if (delta == null) {
            return;
        }
        if (this.options.getMethod(this.association) == IDeltaComputationOptions.ComputationMethod.BY_POSITION) {
            this.createChildDeltasPerPosition(delta, originals, refObjects);
        } else if (this.options.getMethod(this.association) == IDeltaComputationOptions.ComputationMethod.BY_OBJECT) {
            this.createChildDeltasPerObject(delta, originals, refObjects);
        } else {
            throw new RuntimeException("Unknown delta computation method " + (Object)((Object)this.options.getMethod(this.association)));
        }
    }

    private void createChildDeltasPerPosition(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects) {
        int max = Math.max(originals.size(), refObjects.size());
        int i = 0;
        while (i < max) {
            if (this.hasObject(originals, i)) {
                IModelObject original = originals.get(i);
                if (this.hasObject(refObjects, i)) {
                    IModelObject refObject = refObjects.get(i);
                    if (this.options.isSame(original, refObject)) {
                        delta.addChildDelta(((IDeltaSupport)((Object)original)).computeDelta(refObject, this.options));
                    } else {
                        delta.addChildDelta(ModelObjectDelta.newDifferentObjectAtPositionChangedDelta(original, refObject, this.association));
                    }
                } else {
                    delta.addChildDelta(ModelObjectDelta.newRemoveDelta(original, this.association, this.options));
                }
            } else if (this.hasObject(refObjects, i)) {
                delta.addChildDelta(ModelObjectDelta.newAddDelta(refObjects.get(i), this.association, this.options));
            } else {
                throw new RuntimeException("Error in delta computation. Both objects null in assocation " + this.association);
            }
            ++i;
        }
    }

    private <T> boolean hasObject(Collection<T> collection, int index) {
        return index < collection.size();
    }

    private void createChildDeltasPerObject(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects) {
        int removeCounter = 0;
        int size = originals.size();
        int i = 0;
        while (i < size) {
            IModelObjectDelta childDelta = this.createRemoveMoveOrChangeDelta(originals.get(i), i, refObjects);
            delta.addChildDelta(childDelta);
            if (childDelta.isRemoved()) {
                ++removeCounter;
            }
            ++i;
        }
        int refSize = refObjects.size();
        if (size - removeCounter == refSize) {
            return;
        }
        int i2 = 0;
        while (i2 < refSize) {
            boolean exists = false;
            int j = 0;
            while (j < size) {
                if (this.options.isSame(originals.get(j), refObjects.get(i2))) {
                    exists = true;
                    break;
                }
                ++j;
            }
            if (!exists) {
                delta.addChildDelta(ModelObjectDelta.newAddDelta(refObjects.get(i2), this.association, this.options));
            }
            ++i2;
        }
    }

    private final IModelObjectDelta createRemoveMoveOrChangeDelta(IModelObject original, int position, List<? extends IModelObject> refObjects) {
        int refSize = refObjects.size();
        if (position < refSize && this.options.isSame(original, refObjects.get(position))) {
            IModelObjectDelta childDelta = ((IDeltaSupport)((Object)original)).computeDelta(refObjects.get(position), this.options);
            return childDelta;
        }
        int i = 0;
        while (i < refSize) {
            IModelObject refModelObject;
            if (i != position && this.options.isSame(original, refModelObject = refObjects.get(i))) {
                IModelObjectDelta childDelta = ((IDeltaSupport)((Object)original)).computeDelta(refModelObject, this.options);
                ((ModelObjectDelta)childDelta).markMoved();
                return childDelta;
            }
            ++i;
        }
        return ModelObjectDelta.newRemoveDelta(original, this.association, this.options);
    }
}

