/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.faktorips.runtime.IValidationContext;

public class ValidationContext
implements IValidationContext {
    private final Locale locale;
    private final Map<String, Object> propertyValues = new HashMap<String, Object>();
    private final ClassLoader resourceClassLoader;

    public ValidationContext(Locale locale, ClassLoader resourceClassLoader) {
        if (locale == null) {
            throw new NullPointerException("The parameter locale cannot be null.");
        }
        if (resourceClassLoader == null) {
            throw new NullPointerException("The parameter resourceClassLoader cannot be null.");
        }
        this.locale = locale;
        this.resourceClassLoader = resourceClassLoader;
    }

    public ValidationContext(Locale locale) {
        this(locale, ValidationContext.class.getClassLoader());
    }

    public ValidationContext() {
        this(Locale.getDefault());
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Object getValue(String propertyName) {
        return this.propertyValues.get(propertyName);
    }

    public void setValue(String propertyName, Object value) {
        this.propertyValues.put(propertyName, value);
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }
}

