/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider;

import org.faktorips.runtime.DefaultCacheFactory;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepositoryManager;
import org.faktorips.runtime.formula.IFormulaEvaluatorFactory;
import org.faktorips.runtime.internal.AbstractRuntimeRepositoryManager;
import org.faktorips.runtime.productdataprovider.DetachedContentRuntimeRepository;
import org.faktorips.runtime.productdataprovider.IDetachedContentRuntimeRepository;
import org.faktorips.runtime.productdataprovider.IProductDataProviderFactory;

public class DetachedContentRuntimeRepositoryManager
extends AbstractRuntimeRepositoryManager {
    private final Builder builder;

    private DetachedContentRuntimeRepositoryManager(Builder builder) {
        this.builder = builder;
    }

    @Override
    @Deprecated
    public synchronized IDetachedContentRuntimeRepository getActualRuntimeRepository() {
        return this.getCurrentRuntimeRepository();
    }

    @Override
    public synchronized IDetachedContentRuntimeRepository getCurrentRuntimeRepository() {
        IRuntimeRepository currentRuntimeRepository = super.getCurrentRuntimeRepository();
        if (currentRuntimeRepository instanceof DetachedContentRuntimeRepository) {
            return (IDetachedContentRuntimeRepository)currentRuntimeRepository;
        }
        throw new RuntimeException("Illegal repository class in detached content runtime repository.");
    }

    @Override
    protected boolean isRepositoryUpToDate(IRuntimeRepository actualRuntimeRepository) {
        if (actualRuntimeRepository instanceof DetachedContentRuntimeRepository) {
            DetachedContentRuntimeRepository detachedContentRR = (DetachedContentRuntimeRepository)actualRuntimeRepository;
            return detachedContentRR.isUpToDate();
        }
        return false;
    }

    @Override
    protected IRuntimeRepository createNewRuntimeRepository() {
        return new DetachedContentRuntimeRepository(this.builder.getRepositoryName(), this.builder.getCacheFactory(), this.builder.getClassLoader(), this.builder.getProductDataProviderFactory().newInstance(), this.builder.getFormulaEvaluatorFactory());
    }

    /* synthetic */ DetachedContentRuntimeRepositoryManager(Builder builder, DetachedContentRuntimeRepositoryManager detachedContentRuntimeRepositoryManager) {
        this(builder);
    }

    public static class Builder {
        private final IProductDataProviderFactory dataProviderFactory;
        private String repositoryName = "";
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private IFormulaEvaluatorFactory formulaEvaluatorFactory;
        private ICacheFactory cacheFactory = new DefaultCacheFactory(this.classLoader);

        public Builder(IProductDataProviderFactory productDataProviderFactory) {
            this.dataProviderFactory = productDataProviderFactory;
        }

        IProductDataProviderFactory getProductDataProviderFactory() {
            return this.dataProviderFactory;
        }

        public Builder setRepositoryName(String name) {
            this.repositoryName = name;
            return this;
        }

        String getRepositoryName() {
            return this.repositoryName;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Builder setFormulaEvaluatorFactory(IFormulaEvaluatorFactory formulaEvaluatorFactory) {
            this.formulaEvaluatorFactory = formulaEvaluatorFactory;
            return this;
        }

        IFormulaEvaluatorFactory getFormulaEvaluatorFactory() {
            return this.formulaEvaluatorFactory;
        }

        public Builder setCacheFactory(ICacheFactory cacheFactory) {
            this.cacheFactory = cacheFactory;
            return this;
        }

        ICacheFactory getCacheFactory() {
            return this.cacheFactory;
        }

        public IRuntimeRepositoryManager build() {
            return new DetachedContentRuntimeRepositoryManager(this, null);
        }
    }
}

