/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.faktorips.runtime.GenerationId;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.AbstractCachingRuntimeRepository;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ModelTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;

public abstract class AbstractTocBasedRuntimeRepository
extends AbstractCachingRuntimeRepository {
    private volatile IReadonlyTableOfContents toc;

    public AbstractTocBasedRuntimeRepository(String name, ICacheFactory cacheFactory, ClassLoader cl) {
        super(name, cacheFactory, cl);
    }

    protected abstract IReadonlyTableOfContents loadTableOfContents();

    private void setTableOfContents(IReadonlyTableOfContents toc) {
        this.toc = toc;
    }

    protected IReadonlyTableOfContents getTableOfContents() {
        return this.toc;
    }

    protected abstract <T> List<T> createEnumValues(EnumContentTocEntry var1, Class<T> var2);

    @Override
    protected final IProductComponent getProductComponentInternal(String kindId, String versionId) {
        ProductCmptTocEntry entry = this.toc.getProductCmptTocEntry(kindId, versionId);
        if (entry == null) {
            return null;
        }
        return this.getProductComponent(entry.getIpsObjectId());
    }

    @Override
    public void getAllProductComponents(String kindId, List<IProductComponent> result) {
        for (ProductCmptTocEntry entry : this.toc.getProductCmptTocEntries(kindId)) {
            result.add(this.getProductComponent(entry.getIpsObjectId()));
        }
    }

    @Override
    public void getAllProductComponents(List<IProductComponent> result) {
        for (TocEntryObject tocEntryObject : this.toc.getProductCmptTocEntries()) {
            result.add(this.getProductComponent(tocEntryObject.getIpsObjectId()));
        }
    }

    @Override
    public void getAllProductComponentIds(List<String> result) {
        List<ProductCmptTocEntry> entries = this.toc.getProductCmptTocEntries();
        for (TocEntryObject tocEntryObject : entries) {
            result.add(tocEntryObject.getIpsObjectId());
        }
    }

    protected abstract IProductComponent createProductCmpt(ProductCmptTocEntry var1);

    @Override
    protected IProductComponentGeneration getProductComponentGenerationInternal(String id, Calendar effectiveDate) {
        ProductCmptTocEntry tocEntry = this.toc.getProductCmptTocEntry(id);
        if (tocEntry == null) {
            return null;
        }
        GenerationTocEntry generationTocEntry = tocEntry.getGenerationEntry(effectiveDate);
        if (generationTocEntry == null) {
            return null;
        }
        return this.getProductComponentGenerationInternal(id, generationTocEntry.getValidFrom());
    }

    @Override
    protected IProductComponentGeneration getNextProductComponentGenerationInternal(IProductComponentGeneration generation) {
        String id = generation.getProductComponent().getId();
        ProductCmptTocEntry tocEntry = this.toc.getProductCmptTocEntry(id);
        Date validFromAsDate = generation.getValidFrom(TimeZone.getDefault());
        Calendar validFromAsCalendar = Calendar.getInstance();
        validFromAsCalendar.setTime(validFromAsDate);
        GenerationTocEntry generationTocEntry = tocEntry.getNextGenerationEntry(validFromAsCalendar);
        if (generationTocEntry == null) {
            return null;
        }
        return this.getProductComponentGenerationInternal(id, generationTocEntry.getValidFrom());
    }

    @Override
    protected IProductComponentGeneration getPreviousProductComponentGenerationInternal(IProductComponentGeneration generation) {
        String id = generation.getProductComponent().getId();
        ProductCmptTocEntry tocEntry = this.toc.getProductCmptTocEntry(id);
        Date validFromAsDate = generation.getValidFrom(TimeZone.getDefault());
        Calendar validFromAsCalendar = Calendar.getInstance();
        validFromAsCalendar.setTime(validFromAsDate);
        GenerationTocEntry generationTocEntry = tocEntry.getPreviousGenerationEntry(validFromAsCalendar);
        if (generationTocEntry == null) {
            return null;
        }
        return this.getProductComponentGenerationInternal(id, generationTocEntry.getValidFrom());
    }

    @Override
    protected IProductComponentGeneration getLatestProductComponentGenerationInternal(IProductComponent productCmpt) {
        if (productCmpt == null) {
            throw new NullPointerException("The parameter productCmpt must not be null.");
        }
        ProductCmptTocEntry tocEntry = this.toc.getProductCmptTocEntry(productCmpt.getId());
        GenerationTocEntry entryGeneration = tocEntry.getLatestGenerationEntry();
        return this.getProductComponentGenerationInternal(productCmpt.getId(), entryGeneration.getValidFrom());
    }

    @Override
    public void getProductComponentGenerations(IProductComponent productCmpt, List<IProductComponentGeneration> result) {
        if (productCmpt.getRepository() != this) {
            return;
        }
        ProductCmptTocEntry entry = this.toc.getProductCmptTocEntry(productCmpt.getId());
        List<GenerationTocEntry> genEntries = entry.getGenerationEntries();
        for (GenerationTocEntry genEntry : genEntries) {
            IProductComponentGeneration gen = this.getProductComponentGeneration(productCmpt.getId(), genEntry.getValidFrom().toGregorianCalendar(TimeZone.getDefault()));
            result.add(gen);
        }
    }

    @Override
    protected int getNumberOfProductComponentGenerationsInternal(IProductComponent productCmpt) {
        ProductCmptTocEntry tocEntry = this.toc.getProductCmptTocEntry(productCmpt.getId());
        return tocEntry.getNumberOfGenerationEntries();
    }

    @Override
    protected IProductComponentGeneration getNotCachedProductComponentGeneration(GenerationId generationId) {
        ProductCmptTocEntry tocEntry = this.toc.getProductCmptTocEntry(generationId.getQName());
        if (tocEntry == null) {
            return null;
        }
        GenerationTocEntry generationTocEntry = tocEntry.getGenerationEntry(generationId.getValidFrom());
        if (generationTocEntry == null) {
            return null;
        }
        return this.createProductCmptGeneration(generationTocEntry);
    }

    protected abstract IProductComponentGeneration createProductCmptGeneration(GenerationTocEntry var1);

    @Override
    public void getAllTables(List<ITable<?>> result) {
        for (TocEntryObject tocEntryObject : this.toc.getTableTocEntries()) {
            result.add(this.getTable(tocEntryObject.getIpsObjectQualifiedName()));
        }
    }

    @Override
    protected <T extends ITable<?>> T getTableInternal(Class<T> tableClass) {
        TableContentTocEntry tocEntry = this.toc.getTableTocEntryByClassname(tableClass.getName());
        if (tocEntry == null) {
            return null;
        }
        return (T)((ITable)tableClass.cast(this.getTable(tocEntry.getIpsObjectQualifiedName())));
    }

    private ITable<?> getTableInternal(TableContentTocEntry tocEntry) {
        if (tocEntry == null) {
            return null;
        }
        ITable<?> table = this.createTable(tocEntry);
        return table;
    }

    @Override
    protected ITable<?> getNotCachedTable(String qualifiedTableName) {
        TableContentTocEntry tocEntry = this.toc.getTableTocEntryByQualifiedTableName(qualifiedTableName);
        return this.getTableInternal(tocEntry);
    }

    protected abstract ITable<?> createTable(TableContentTocEntry var1);

    @Override
    protected void getAllIpsTestCases(List<IpsTest2> result, IRuntimeRepository runtimeRepository) {
        for (TocEntryObject tocEntryObject : this.toc.getTestCaseTocEntries()) {
            result.add(this.getIpsTestCase(tocEntryObject.getIpsObjectQualifiedName(), runtimeRepository));
        }
    }

    @Override
    protected void getIpsTestCasesStartingWith(String qNamePrefix, List<IpsTest2> result, IRuntimeRepository runtimeRepository) {
        for (TocEntryObject tocEntryObject : this.toc.getTestCaseTocEntries()) {
            if (!tocEntryObject.getIpsObjectQualifiedName().startsWith(qNamePrefix)) continue;
            result.add(this.getIpsTestCase(tocEntryObject.getIpsObjectQualifiedName(), runtimeRepository));
        }
    }

    protected abstract IpsTestCaseBase createTestCase(TestCaseTocEntry var1, IRuntimeRepository var2);

    protected void initialize() {
        this.setTableOfContents(this.loadTableOfContents());
    }

    protected Class<?> getClass(String className, ClassLoader cl) {
        try {
            Class<?> clazz = cl.loadClass(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't load class " + className, e);
        }
    }

    @Override
    protected void getAllModelTypeImplementationClasses(Set<String> result) {
        Set<ModelTypeTocEntry> entries = this.toc.getModelTypeTocEntries();
        for (TocEntryObject tocEntryObject : entries) {
            result.add(tocEntryObject.getImplementationClassName());
        }
    }

    protected XmlAdapter<String, ?> createEnumXmlAdapter(String className, IRuntimeRepository repository) throws Exception {
        Class<?> xmlAdapterClass = this.getClassLoader().loadClass(className);
        Constructor<?> constructor = xmlAdapterClass.getConstructor(IRuntimeRepository.class);
        XmlAdapter instance = (XmlAdapter)constructor.newInstance(repository);
        return instance;
    }

    @Override
    protected IProductComponent getNotCachedProductComponent(String id) {
        ProductCmptTocEntry tocEntry = this.toc.getProductCmptTocEntry(id);
        if (tocEntry == null) {
            return null;
        }
        IProductComponent pc = this.createProductCmpt(tocEntry);
        return pc;
    }

    @Override
    protected <T> List<T> getNotCachedEnumValues(Class<T> clazz) {
        EnumContentTocEntry tocEntries = this.toc.getEnumContentTocEntry(clazz.getName());
        if (tocEntries == null) {
            return null;
        }
        List<T> enumValues = this.createEnumValues(tocEntries, clazz);
        return enumValues;
    }

    @Override
    protected List<XmlAdapter<?, ?>> getNotCachedEnumXmlAdapter(IRuntimeRepository repository) {
        ArrayList enumXmlAdapters = new ArrayList();
        for (TocEntry tocEntry : this.toc.getEnumXmlAdapterTocEntries()) {
            try {
                enumXmlAdapters.add(this.createEnumXmlAdapter(tocEntry.getImplementationClassName(), repository));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create an XmlAdapter for the enumeration: " + tocEntry.getImplementationClassName(), e);
            }
        }
        return enumXmlAdapters;
    }

    @Override
    protected synchronized IpsTestCaseBase getIpsTestCaseInternal(String qName, IRuntimeRepository runtimeRepository) {
        TestCaseTocEntry tocEntry = this.toc.getTestCaseTocEntryByQName(qName);
        if (tocEntry == null) {
            return null;
        }
        return this.createTestCase(tocEntry, runtimeRepository);
    }

    @Override
    protected <T> T getNotCachedCustomObject(Class<T> type, String id) {
        CustomTocEntryObject<T> tocEntry = this.toc.getCustomTocEntry(type, id);
        if (tocEntry == null) {
            return null;
        }
        try {
            return this.createCustomObject(tocEntry);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract <T> T createCustomObject(CustomTocEntryObject<T> var1);
}

