/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.Calendar;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.runtime.modeltype.IModelTypeAttribute;

public abstract class Attribute
extends TypePart
implements IModelTypeAttribute {
    private final IpsAttribute attributeAnnotation;
    private final Class<?> datatype;
    private final boolean changingOverTime;

    public Attribute(Type type, IpsAttribute attributeAnnotation, IpsExtensionProperties extensionProperties, Class<?> datatype, boolean changingOverTime) {
        super(attributeAnnotation.name(), type, extensionProperties);
        this.attributeAnnotation = attributeAnnotation;
        this.datatype = datatype;
        this.changingOverTime = changingOverTime;
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    @Override
    public abstract boolean isProductRelevant();

    @Override
    public Class<?> getDatatype() {
        return this.datatype;
    }

    public AttributeKind getAttributeKind() {
        return this.attributeAnnotation.kind();
    }

    @Override
    @Deprecated
    public IModelTypeAttribute.AttributeType getAttributeType() {
        return IModelTypeAttribute.AttributeType.forName(this.getAttributeKind().name());
    }

    public ValueSetKind getValueSetKind() {
        return this.attributeAnnotation.valueSetKind();
    }

    @Override
    @Deprecated
    public IModelTypeAttribute.ValueSetType getValueSetType() {
        return IModelTypeAttribute.ValueSetType.valueOf(this.getValueSetKind().name());
    }

    public boolean isOverriding() {
        return this.getType().isSuperTypePresent() && this.getType().getSuperType().isAttributePresent(this.getName());
    }

    public Attribute getSuperAttribute() {
        return this.isOverriding() ? this.getType().getSuperType().getAttribute(this.getName()) : null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append(this.datatype.getSimpleName());
        sb.append('(');
        sb.append((Object)this.getAttributeKind());
        sb.append(", ");
        sb.append((Object)this.getValueSetKind());
        if (this.isProductRelevant()) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }

    public abstract Attribute createOverwritingAttributeFor(Type var1);

    protected Object getRelevantProductObject(IProductComponent productComponent, Calendar effectiveDate) {
        return Attribute.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime());
    }
}

