/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsConfiguredAttribute;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.valueset.ValueSet;

public class DefaultPolicyAttribute
extends PolicyAttribute {
    private final Method getter;
    private final Method setter;
    private Method defaultValueMethod;
    private Map<Type, Method> valueSetMethods = new HashMap<Type, Method>(2);

    public DefaultPolicyAttribute(PolicyCmptType policyCmptType, Method getter, Method setter, boolean changingOverTime) {
        super(policyCmptType, getter.getAnnotation(IpsAttribute.class), getter.getAnnotation(IpsExtensionProperties.class), getter.getReturnType(), changingOverTime);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public boolean isProductRelevant() {
        return this.getter.isAnnotationPresent(IpsConfiguredAttribute.class);
    }

    @Override
    public Object getValue(IModelObject modelObject) {
        return this.invokeMethod(this.getter, modelObject, new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(IModelObject modelObject, Object value) {
        if (this.setter == null) {
            if (!this.isOverriding()) throw new IllegalArgumentException(String.format("There is no setter for attribute %s in type %s.", this.getName(), this.getType().getName()));
            this.getSuperAttribute().setValue(modelObject, value);
            return;
        } else {
            this.invokeMethod(this.setter, modelObject, value);
        }
    }

    @Override
    public Object getDefaultValue(IConfigurableModelObject modelObject) {
        return this.getDefaultValue(modelObject.getProductComponent(), modelObject.getEffectiveFromAsCalendar());
    }

    @Override
    public Object getDefaultValue(IProductComponent source, Calendar effectiveDate) {
        if (!this.isProductRelevant()) {
            throw new IllegalStateException("Trying to find default value method in product class, but policy attribute " + this.getType().getName() + '.' + this.getName() + " is not configurable.");
        }
        return this.invokeMethod(this.getDefaultValueMethod(this.getType().getProductCmptType()), this.getRelevantProductObject(source, effectiveDate), new Object[0]);
    }

    private Method getDefaultValueMethod(Type type) {
        if (this.defaultValueMethod == null) {
            this.defaultValueMethod = this.findDefaultValueMethod(type);
        }
        return this.defaultValueMethod;
    }

    private Method findDefaultValueMethod(Type type) {
        Type.AnnotatedElementMatcher<IpsDefaultValue> filter = new Type.AnnotatedElementMatcher<IpsDefaultValue>(){

            @Override
            public boolean matches(IpsDefaultValue ann) {
                return ann.value().equals(DefaultPolicyAttribute.this.getName());
            }
        };
        return this.findMethod(IpsDefaultValue.class, filter, "default value", type);
    }

    @Override
    public ValueSet<?> getValueSet(IModelObject modelObject, IValidationContext context) {
        return (ValueSet)this.invokeMethod(this.getValueSetMethod(this.getType()), modelObject, context);
    }

    @Override
    public ValueSet<?> getValueSet(IProductComponent source, Calendar effectiveDate, IValidationContext context) {
        return (ValueSet)this.invokeMethod(this.getValueSetMethod(this.getType().getProductCmptType()), this.getRelevantProductObject(source, effectiveDate), context);
    }

    private Method getValueSetMethod(Type model) {
        Method valueSetMethod = this.valueSetMethods.get(model);
        if (valueSetMethod == null) {
            valueSetMethod = this.findValueSetMethod(model);
            this.valueSetMethods.put(model, valueSetMethod);
        }
        return valueSetMethod;
    }

    @Override
    public DefaultPolicyAttribute createOverwritingAttributeFor(Type subType) {
        return new DefaultPolicyAttribute((PolicyCmptType)subType, this.getter, this.setter, this.isChangingOverTime());
    }

    private Method findValueSetMethod(Type type) {
        Type.AnnotatedElementMatcher<IpsAllowedValues> filter = new Type.AnnotatedElementMatcher<IpsAllowedValues>(){

            @Override
            public boolean matches(IpsAllowedValues ann) {
                return ann.value().equals(DefaultPolicyAttribute.this.getName());
            }
        };
        return this.findMethod(IpsAllowedValues.class, filter, "allowed values", type);
    }

    private <T extends Annotation> Method findMethod(Class<T> annotationClass, Type.AnnotatedElementMatcher<T> filter, String methodDescription, Type type) {
        Method method = type.searchDeclaredMethod(annotationClass, filter);
        if (method == null) {
            throw new IllegalStateException("No method found for retrieving the " + methodDescription + " of attribute: " + this.getName());
        }
        return method;
    }
}

