/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.faktorips.runtime.IMarker;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.util.function.IPredicate;
import org.faktorips.values.ObjectUtil;

public class MessageList
implements Serializable,
Iterable<Message> {
    private static final long serialVersionUID = 5518835977871253111L;
    private List<Message> messages = new ArrayList<Message>(0);

    public MessageList() {
    }

    public MessageList(Message message) {
        this.add(message);
    }

    public static final MessageList createCopy(MessageList list, Object oldObject, Object newObject) {
        MessageList newList = new MessageList();
        for (Message message : list) {
            newList.add(Message.createCopy(message, oldObject, newObject));
        }
        return newList;
    }

    public void add(Message message) {
        if (message != null) {
            this.messages.add(message);
        }
    }

    public void add(MessageList messageList) {
        if (messageList == null) {
            return;
        }
        for (Message message : messageList) {
            this.add(message);
        }
    }

    public void add(MessageList messageList, ObjectProperty invalidObjectProperty, boolean override) {
        if (messageList == null) {
            return;
        }
        for (Message message : messageList) {
            if (override || message.getInvalidObjectProperties().size() == 0) {
                this.add(new Message(message.getCode(), message.getText(), message.getSeverity(), invalidObjectProperty));
                continue;
            }
            this.add(message);
        }
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Deprecated
    public int getNoOfMessages() {
        return this.size();
    }

    public int size() {
        return this.messages.size();
    }

    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    public Message getFirstMessage(Severity severity) {
        for (Message message : this.messages) {
            if (message.getSeverity() != severity) continue;
            return message;
        }
        return null;
    }

    public Message getMessageWithHighestSeverity() {
        Message result = null;
        for (Message message : this.messages) {
            if (result == null) {
                result = message;
                continue;
            }
            if (result.getSeverity().compareTo(message.getSeverity()) >= 0) continue;
            result = message;
        }
        return result;
    }

    public Message getMessageByCode(String code) {
        for (Message message : this.messages) {
            if (!ObjectUtil.equals((Object)message.getCode(), (Object)code)) continue;
            return message;
        }
        return null;
    }

    public MessageList getMessagesByCode(String code) {
        MessageList sublist = new MessageList();
        for (Message message : this.messages) {
            if (!ObjectUtil.equals((Object)message.getCode(), (Object)code)) continue;
            sublist.add(message);
        }
        return sublist;
    }

    public MessageList getMessagesByMarker(IMarker marker) {
        MessageList sublist = new MessageList();
        for (Message message : this.messages) {
            Set<? extends IMarker> markers = message.getMarkers();
            if ((marker != null || !markers.isEmpty()) && !markers.contains(marker)) continue;
            sublist.add(message);
        }
        return sublist;
    }

    public MessageList getMessagesByMarker(IPredicate<IMarker> markerPredicate) {
        if (markerPredicate == null) {
            throw new NullPointerException("markerPredicate must not be null");
        }
        MessageList sublist = new MessageList();
        block0: for (Message message : this.messages) {
            for (IMarker iMarker : message.getMarkers()) {
                if (!markerPredicate.test(iMarker)) continue;
                sublist.add(message);
                continue block0;
            }
        }
        return sublist;
    }

    public Severity getSeverity() {
        Severity severity = Severity.NONE;
        for (Message message : this.messages) {
            if (message.getSeverity().compareTo(severity) <= 0) continue;
            severity = message.getSeverity();
        }
        return severity;
    }

    public String getText() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            if (i > 0) {
                s.append(lineSeparator);
            }
            s.append(this.getMessage(i).getText());
            ++i;
        }
        return s.toString();
    }

    public boolean containsErrorMsg() {
        for (Message message : this.messages) {
            if (message.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public MessageList getMessagesFor(Object object) {
        return this.getMessagesFor(object, null);
    }

    public MessageList getMessagesFor(Object object, String property, int index) {
        MessageList result = new MessageList();
        block0: for (Message message : this.messages) {
            List<ObjectProperty> op = message.getInvalidObjectProperties();
            for (ObjectProperty objectProperty : op) {
                if (!objectProperty.getObject().equals(object)) continue;
                if (property == null) {
                    result.add(message);
                    continue block0;
                }
                if (!property.equals(objectProperty.getProperty()) || index >= 0 && objectProperty.getIndex() != index) continue;
                result.add(message);
                continue block0;
            }
        }
        return result;
    }

    public MessageList getMessagesFor(Object object, String property) {
        return this.getMessagesFor(object, property, -1);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    public void clear() {
        this.messages.clear();
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer s = new StringBuffer();
        for (Message message : this.messages) {
            s.append(String.valueOf(message.toString()) + lineSeparator);
        }
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messages == null ? 0 : this.messages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageList other = (MessageList)obj;
        return !(this.messages == null ? other.messages != null : !this.messages.equals(other.messages));
    }
}

