/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider;

import java.io.InputStream;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.formula.IFormulaEvaluatorFactory;
import org.faktorips.runtime.internal.AbstractClassLoadingRuntimeRepository;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.productdataprovider.DataModifiedException;
import org.faktorips.runtime.productdataprovider.DataModifiedRuntimeException;
import org.faktorips.runtime.productdataprovider.IDetachedContentRuntimeRepository;
import org.faktorips.runtime.productdataprovider.IProductDataProvider;
import org.w3c.dom.Element;

public class DetachedContentRuntimeRepository
extends AbstractClassLoadingRuntimeRepository
implements IDetachedContentRuntimeRepository {
    private final IProductDataProvider productDataProvider;
    private final IFormulaEvaluatorFactory formulaEvaluatorFactory;

    DetachedContentRuntimeRepository(String repositoryName, ICacheFactory cacheFactory, ClassLoader classLoader, IProductDataProvider productDataProvider, IFormulaEvaluatorFactory formulaEvaluatorFactory) {
        super(repositoryName, cacheFactory, classLoader);
        this.productDataProvider = productDataProvider;
        this.formulaEvaluatorFactory = formulaEvaluatorFactory;
        super.initialize();
    }

    @Override
    protected IReadonlyTableOfContents loadTableOfContents() {
        IReadonlyTableOfContents toc = this.productDataProvider.getToc();
        return toc;
    }

    @Override
    public IFormulaEvaluatorFactory getFormulaEvaluatorFactory() {
        return this.formulaEvaluatorFactory;
    }

    @Override
    protected Element getDocumentElement(ProductCmptTocEntry tocEntry) {
        try {
            return this.productDataProvider.getProductCmptData(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedRuntimeException(e);
        }
    }

    @Override
    protected Element getDocumentElement(GenerationTocEntry tocEntry) {
        try {
            return this.productDataProvider.getProductCmptGenerationData(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedRuntimeException(e);
        }
    }

    @Override
    protected Element getDocumentElement(TestCaseTocEntry tocEntry) {
        try {
            return this.productDataProvider.getTestcaseElement(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedRuntimeException(e);
        }
    }

    @Override
    protected String getProductComponentGenerationImplClass(GenerationTocEntry tocEntry) {
        if (this.getFormulaEvaluatorFactory() != null) {
            return tocEntry.getParent().getGenerationImplClassName();
        }
        return tocEntry.getImplementationClassName();
    }

    @Override
    protected InputStream getXmlAsStream(EnumContentTocEntry tocEntry) {
        try {
            return this.productDataProvider.getEnumContentAsStream(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedRuntimeException(e);
        }
    }

    @Override
    protected InputStream getXmlAsStream(TableContentTocEntry tocEntry) {
        try {
            return this.productDataProvider.getTableContentAsStream(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedRuntimeException(e);
        }
    }

    @Override
    public String getProductDataVersion() {
        return this.productDataProvider.getVersion();
    }

    boolean isUpToDate() {
        return this.productDataProvider.isCompatibleToBaseVersion();
    }

    private RuntimeException createDataModifiedRuntimeException(DataModifiedException e) {
        return new DataModifiedRuntimeException(e);
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    protected <T> Element getDocumentElement(CustomTocEntryObject<T> tocEntry) {
        try {
            return this.productDataProvider.getTocEntryData(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedRuntimeException(e);
        }
    }
}

