/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type.read;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.type.ProductAttribute;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.read.AbstractAttributeDescriptor;
import org.faktorips.runtime.model.type.read.AttributeCollector;

public class ProductAttributeCollector
extends AttributeCollector<ProductAttribute, ProductAttributeDescriptor> {
    public ProductAttributeCollector() {
        super(Arrays.asList(new ProductIpsAttributeProcessor(), new AttributeCollector.IpsAttributeSetterProcessor()));
    }

    @Override
    protected ProductAttributeDescriptor createDescriptor() {
        return new ProductAttributeDescriptor();
    }

    protected static class ProductAttributeDescriptor
    extends AbstractAttributeDescriptor<ProductAttribute> {
        private boolean changingOverTime;

        protected ProductAttributeDescriptor() {
        }

        @Override
        public ProductAttribute createValid(Type type) {
            return new ProductAttribute(type, this.isChangingOverTime(), (Method)this.getAnnotatedElement(), this.getSetterMethod());
        }

        public boolean isChangingOverTime() {
            return this.changingOverTime;
        }

        public void setChangingOverTime(boolean changingOverTime) {
            this.changingOverTime = changingOverTime;
        }
    }

    static class ProductIpsAttributeProcessor
    extends AttributeCollector.IpsAttributeProcessor<ProductAttributeDescriptor> {
        ProductIpsAttributeProcessor() {
        }

        @Override
        public void process(ProductAttributeDescriptor descriptor, AnnotatedDeclaration annotatedDeclaration, AnnotatedElement annotatedElement) {
            descriptor.setChangingOverTime(IProductComponentGeneration.class.isAssignableFrom(annotatedDeclaration.getImplementationClass()));
            descriptor.setAnnotatedElement(annotatedElement);
        }
    }
}

