/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.Table;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TableSaxHandler
extends DefaultHandler {
    private static final String NULL_VALUE = "\\N";
    private static final String CSV_FORMAT = "CSV";
    private static final String VALUE = "Value";
    private static final String ROW = "Row";
    private static final String ROWS = "Rows";
    private static final String PROPERTY_FORMAT = "format";
    private Table<?> table;
    private List<String> columns = new ArrayList<String>(20);
    private StringBuffer textBuffer = null;
    private boolean insideRowNode;
    private boolean insideCsvContent;
    private boolean insideValueNode;
    private boolean nullValue;
    private IRuntimeRepository productRepository;

    public TableSaxHandler(Table<?> table, IRuntimeRepository productRepository) {
        this.table = table;
        this.productRepository = productRepository;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ROWS.equals(qName) && this.insideCsvContent) {
            this.insideCsvContent = false;
            this.initFromCsv(this.getText());
        } else if (ROW.equals(qName)) {
            this.insideRowNode = false;
            this.table.addRow(this.columns, this.productRepository);
            this.columns.clear();
        } else if (this.isColumnValueNode(qName)) {
            this.insideValueNode = false;
            this.columns.add(this.getText());
            this.textBuffer = null;
        }
    }

    private String getText() {
        if (this.textBuffer != null) {
            return this.textBuffer.toString();
        }
        return this.nullValue ? null : "";
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (ROWS.equals(qName)) {
            this.insideCsvContent = this.isFormatCsv(attributes);
        } else if (ROW.equals(qName)) {
            this.insideRowNode = true;
        } else if (this.isColumnValueNode(qName)) {
            this.insideValueNode = true;
            this.nullValue = Boolean.valueOf(attributes.getValue("isNull"));
        }
    }

    private boolean isFormatCsv(Attributes attributes) {
        String format = attributes.getValue(PROPERTY_FORMAT);
        return CSV_FORMAT.equals(format);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (!this.insideValueNode && !this.insideCsvContent) {
            return;
        }
        String s = new String(buf, offset, len);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    private boolean isColumnValueNode(String nodeName) {
        return VALUE.equals(nodeName) && this.insideRowNode;
    }

    private void initFromCsv(String csv) {
        StringReader stringReader = new StringReader(csv);
        try {
            this.getClass().getClassLoader().loadClass("com.opencsv.CSVReader");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load OpenCSV", e);
        }
        CSVReader csvReader = new CSVReader((Reader)stringReader, '|', '\"', '\\');
        try {
            try {
                String[] csvLine;
                while ((csvLine = csvReader.readNext()) != null) {
                    int i = 0;
                    while (i < csvLine.length) {
                        if (NULL_VALUE.equals(csvLine[i])) {
                            csvLine[i] = null;
                        }
                        ++i;
                    }
                    this.table.addRow(Arrays.asList(csvLine), this.productRepository);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                csvReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

