/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.Collection;
import java.util.Locale;
import org.faktorips.runtime.internal.EnumValues;
import org.faktorips.runtime.internal.InternationalStringXmlReaderWriter;
import org.faktorips.runtime.internal.Range;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.LocalizedString;
import org.faktorips.valueset.StringLengthValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public enum ValueToXmlHelper {

    public static final String XML_TAG_VALUE = "Value";
    public static final String XML_TAG_VALUE_SET = "ValueSet";
    public static final String XML_TAG_DATA = "Data";
    public static final String LEGACY_XML_TAG_CONFIG_ELEMENT = "ConfigElement";
    public static final String CONFIGURED_DEFAULT_PREFIX = "@default_";
    public static final String CONFIGURED_VALUE_SET_PREFIX = "@valueSet_";
    public static final String XML_TAG_CONFIGURED_DEFAULT = "ConfiguredDefault";
    public static final String XML_TAG_CONFIGURED_VALUE_SET = "ConfiguredValueSet";
    public static final String XML_TAG_ATTRIBUTE_VALUE = "AttributeValue";
    public static final String XML_ATTRIBUTE_ATTRIBUTE = "attribute";
    public static final String XML_TAG_ALL_VALUES = "AllValues";
    public static final String XML_TAG_STRINGLENGTH = "StringLength";
    public static final String XML_TAG_DERIVED = "Derived";
    public static final String XML_TAG_ENUM = "Enum";
    public static final String XML_TAG_RANGE = "Range";
    public static final String XML_TAG_STEP = "Step";
    public static final String XML_TAG_UPPER_BOUND = "UpperBound";
    public static final String XML_TAG_LOWER_BOUND = "LowerBound";
    public static final String XML_TAG_TABLE_CONTENT_NAME = "TableContentName";
    public static final String XML_TAG_TABLE_CONTENT_USAGE = "TableContentUsage";
    public static final String XML_TAG_MAXIMUM_LENGTH = "MaximumLength";
    public static final String XML_ATTRIBUTE_STRUCTURE_USAGE = "structureUsage";
    public static final String XML_ATTRIBUTE_IS_NULL = "isNull";
    public static final String XML_ATTRIBUTE_CONTAINS_NULL = "containsNull";
    public static final String XML_ATTRIBUTE_EMPTY = "empty";

    public static void addValueToElement(String value, Element el, String tagName) {
        ValueToXmlHelper.addValueAndReturnElement(value, el, tagName, false);
    }

    public static void addInternationalStringToElement(DefaultInternationalString value, Element el, String tagName) {
        ValueToXmlHelper.addInternationalStringAndReturnElement(value, el, tagName);
    }

    public static void addCDataValueToElement(String value, Element el, String tagName) {
        ValueToXmlHelper.addValueAndReturnElement(value, el, tagName, true);
    }

    private static Element addValueAndReturnElement(String value, Element el, String tagName, boolean useCDataSection) {
        Document ownerDocument = el.getOwnerDocument();
        Element valueEl = ValueToXmlHelper.createValueElement(value, tagName, ownerDocument, useCDataSection);
        el.appendChild(valueEl);
        return valueEl;
    }

    private static Element addInternationalStringAndReturnElement(DefaultInternationalString value, Element el, String tagName) {
        Document ownerDocument = el.getOwnerDocument();
        Element valueEl = ownerDocument.createElement(tagName);
        Element internationalStringEl = InternationalStringXmlReaderWriter.toXml(ownerDocument, value);
        valueEl.appendChild(internationalStringEl);
        el.appendChild(valueEl);
        return valueEl;
    }

    public static Element createValueElement(String value, String tagName, Document ownerDocument, boolean useCDataSection) {
        Element valueEl = ownerDocument.createElement(tagName);
        ValueToXmlHelper.setValue(value, ownerDocument, useCDataSection, valueEl);
        return valueEl;
    }

    public static void setValue(String value, Element valueEl) {
        ValueToXmlHelper.setValue(value, valueEl.getOwnerDocument(), false, valueEl);
    }

    private static void setValue(String value, Document ownerDocument, boolean useCDataSection, Element valueEl) {
        if (value == null) {
            valueEl.setAttribute(XML_ATTRIBUTE_IS_NULL, Boolean.TRUE.toString());
        } else if (useCDataSection) {
            valueEl.appendChild(ownerDocument.createCDATASection(value));
        } else {
            valueEl.appendChild(ownerDocument.createTextNode(value));
        }
    }

    public static Element addValueAndReturnElement(String value, Element el, String tagName) {
        return ValueToXmlHelper.addValueAndReturnElement(value, el, tagName, false);
    }

    public static void addTableUsageToElement(Element el, String structureUsage, String tableContentName) {
        Element tableContentElement = el.getOwnerDocument().createElement(XML_TAG_TABLE_CONTENT_USAGE);
        tableContentElement.setAttribute(XML_ATTRIBUTE_STRUCTURE_USAGE, structureUsage);
        ValueToXmlHelper.addValueToElement(tableContentName, tableContentElement, XML_TAG_TABLE_CONTENT_NAME);
        el.appendChild(tableContentElement);
    }

    public static String getValueFromElement(Element el, String tagName) {
        Element valueEl = XmlUtil.getFirstElement(el, tagName);
        if (valueEl == null) {
            return null;
        }
        return ValueToXmlHelper.getValueFromElement(valueEl);
    }

    public static DefaultInternationalString getInternationalStringFromElement(Element el, String tagName) {
        Collection<LocalizedString> localizedStrings = InternationalStringXmlReaderWriter.fromXml(el, tagName);
        Locale defaultLocale = InternationalStringXmlReaderWriter.defaultLocaleFromXml(el, tagName);
        return new DefaultInternationalString(localizedStrings, defaultLocale);
    }

    public static String getValueFromElement(Element valueEl) {
        if (Boolean.parseBoolean(valueEl.getAttribute(XML_ATTRIBUTE_IS_NULL))) {
            return null;
        }
        Text text = XmlUtil.getTextNode(valueEl);
        if (text != null) {
            return text.getData();
        }
        CDATASection cdata = XmlUtil.getFirstCDataSection(valueEl);
        String result = "";
        if (cdata != null) {
            result = cdata.getData();
        }
        return result;
    }

    public static DefaultInternationalString getInternationalStringFromElement(Element el) {
        Collection<LocalizedString> localizedString = InternationalStringXmlReaderWriter.fromXml(el);
        Locale defaultLocale = InternationalStringXmlReaderWriter.defaultLocaleFromXml(el);
        return new DefaultInternationalString(localizedString, defaultLocale);
    }

    public static Range getRangeFromElement(Element el, String tagName) {
        Element valueSetEl = XmlUtil.getFirstElement(el, tagName);
        if (valueSetEl == null) {
            return null;
        }
        Element rangeEl = XmlUtil.getFirstElement(valueSetEl, XML_TAG_RANGE);
        if (rangeEl == null) {
            return null;
        }
        boolean empty = Boolean.valueOf(rangeEl.getAttribute(XML_ATTRIBUTE_EMPTY));
        if (empty) {
            return new Range();
        }
        boolean containsNull = Boolean.valueOf(rangeEl.getAttribute(XML_ATTRIBUTE_CONTAINS_NULL));
        String lowerBound = ValueToXmlHelper.getValueFromElement(rangeEl, XML_TAG_LOWER_BOUND);
        String upperBound = ValueToXmlHelper.getValueFromElement(rangeEl, XML_TAG_UPPER_BOUND);
        String step = ValueToXmlHelper.getValueFromElement(rangeEl, XML_TAG_STEP);
        return new Range(lowerBound, upperBound, step, containsNull);
    }

    public static EnumValues getEnumValueSetFromElement(Element el, String tagName) {
        Element valueSetEl = XmlUtil.getFirstElement(el, tagName);
        if (valueSetEl == null) {
            return null;
        }
        Element enumEl = XmlUtil.getFirstElement(valueSetEl, XML_TAG_ENUM);
        if (enumEl == null) {
            return null;
        }
        NodeList valueElements = enumEl.getElementsByTagName(XML_TAG_VALUE);
        String[] values = new String[valueElements.getLength()];
        boolean containsNull = false;
        int i = 0;
        while (i < valueElements.getLength()) {
            Element valueEl = (Element)valueElements.item(i);
            values[i] = ValueToXmlHelper.getValueFromElement(valueEl, XML_TAG_DATA);
            if (values[i] == null) {
                containsNull = true;
            }
            ++i;
        }
        return new EnumValues(values, containsNull);
    }

    public static StringLengthValueSet getStringLengthValueSetFromElement(Element el, String tagName) {
        Element valueSetEl = XmlUtil.getFirstElement(el, tagName);
        if (valueSetEl == null) {
            return null;
        }
        Element stringLengthEl = XmlUtil.getFirstElement(valueSetEl, XML_TAG_STRINGLENGTH);
        if (stringLengthEl == null) {
            return null;
        }
        Element maximumLengthEl = XmlUtil.getFirstElement(stringLengthEl, XML_TAG_MAXIMUM_LENGTH);
        int maximumLength = Integer.parseInt(maximumLengthEl.getTextContent());
        boolean containsNull = Boolean.valueOf(stringLengthEl.getAttribute(XML_ATTRIBUTE_CONTAINS_NULL));
        return new StringLengthValueSet(Integer.valueOf(maximumLength), containsNull);
    }

    public static <T> UnrestrictedValueSet<T> getUnrestrictedValueSet(Element el, String tagName) {
        Element enumEl;
        Element valueSetEl = XmlUtil.getFirstElement(el, tagName);
        if (valueSetEl != null && (enumEl = XmlUtil.getFirstElement(valueSetEl, XML_TAG_ALL_VALUES)) != null && enumEl.hasAttribute(XML_ATTRIBUTE_CONTAINS_NULL)) {
            boolean containsNull = Boolean.valueOf(enumEl.getAttribute(XML_ATTRIBUTE_CONTAINS_NULL));
            return new UnrestrictedValueSet(containsNull);
        }
        return new UnrestrictedValueSet(true);
    }
}

