/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.enumtype;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.faktorips.runtime.model.annotation.IpsEnumAttribute;
import org.faktorips.runtime.model.annotation.IpsEnumType;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.enumtype.EnumType;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.read.SimpleTypePartsReader;
import org.faktorips.runtime.util.MessagesHelper;

public class EnumAttribute
extends ModelElement {
    private final EnumType enumType;
    private final Class<?> datatype;
    private final Method getterMethod;
    private final IpsEnumAttribute annotation;

    public EnumAttribute(EnumType enumType, String name, Method getterMethod) {
        super(name, getterMethod.getAnnotation(IpsExtensionProperties.class));
        this.enumType = enumType;
        this.datatype = getterMethod.getReturnType();
        this.getterMethod = getterMethod;
        this.annotation = getterMethod.getAnnotation(IpsEnumAttribute.class);
    }

    public Class<?> getDatatype() {
        return this.datatype;
    }

    public boolean isUnique() {
        return this.annotation.unique();
    }

    public boolean isIdentifier() {
        return this.annotation.identifier();
    }

    public boolean isDisplayName() {
        return this.annotation.displayName();
    }

    public Object getValue(Object enumInstance) {
        return this.getValue(enumInstance, Locale.getDefault());
    }

    public boolean isMultilingual() {
        return this.getterMethod.getParameterTypes().length == 1;
    }

    public Object getValue(Object enumInstance, Locale locale) {
        try {
            if (this.isMultilingual()) {
                return this.getterMethod.invoke(enumInstance, locale);
            }
            return this.getterMethod.invoke(enumInstance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw this.cantGetValueException(e, locale);
        }
        catch (IllegalArgumentException e) {
            throw this.cantGetValueException(e, locale);
        }
        catch (InvocationTargetException e) {
            throw this.cantGetValueException(e, locale);
        }
    }

    private RuntimeException cantGetValueException(Exception e, Locale locale) {
        return new RuntimeException("Can't get value for attribute \"" + this.getName() + "\"" + (this.isMultilingual() ? " for locale " + locale : ""), e);
    }

    @Override
    protected String getMessageKey(DocumentationKind messageType) {
        return messageType.getKey(this.enumType.getName(), "EnumType", this.getName());
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.enumType.getMessageHelper();
    }

    protected static LinkedHashMap<String, EnumAttribute> createFrom(EnumType enumType, Class<?> enumClass) {
        Class<IpsEnumType> parentAnnotation = IpsEnumType.class;
        SimpleTypePartsReader.NamesAccessor<IpsEnumType> getNamesOfPartsFromParentAnnotation = new SimpleTypePartsReader.NamesAccessor<IpsEnumType>(){

            @Override
            public String[] getNames(IpsEnumType annotation) {
                return annotation.attributeNames();
            }
        };
        Class<IpsEnumAttribute> childAnnotation = IpsEnumAttribute.class;
        SimpleTypePartsReader.NameAccessor<IpsEnumAttribute> getNameOfPartFromChildAnnotation = new SimpleTypePartsReader.NameAccessor<IpsEnumAttribute>(){

            @Override
            public String getName(IpsEnumAttribute annotation) {
                return annotation.name();
            }
        };
        SimpleTypePartsReader.ModelElementCreator<EnumAttribute> createEnumAttributeModel = new SimpleTypePartsReader.ModelElementCreator<EnumAttribute>(){

            @Override
            public EnumAttribute create(ModelElement modelType, String name, Method getterMethod) {
                return new EnumAttribute((EnumType)modelType, name, getterMethod);
            }
        };
        SimpleTypePartsReader<EnumAttribute, IpsEnumType, IpsEnumAttribute> partsReader = new SimpleTypePartsReader<EnumAttribute, IpsEnumType, IpsEnumAttribute>(parentAnnotation, getNamesOfPartsFromParentAnnotation, childAnnotation, getNameOfPartFromChildAnnotation, createEnumAttributeModel);
        return partsReader.createParts(enumClass, enumType);
    }
}

