/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.enumtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsEnumType;
import org.faktorips.runtime.model.annotation.IpsExtensibleEnum;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.enumtype.EnumAttribute;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.util.MessagesHelper;

public class EnumType
extends ModelElement {
    public static final String KIND_NAME = "EnumType";
    private final MessagesHelper messagesHelper;
    private final List<String> attributeNames;
    private final LinkedHashMap<String, EnumAttribute> attributeModels;
    private final IpsExtensibleEnum ipsExtensibleEnum;
    private final Class<?> enumTypeClass;

    public EnumType(Class<?> enumTypeClass) {
        super(enumTypeClass.getAnnotation(IpsEnumType.class).name(), enumTypeClass.getAnnotation(IpsExtensionProperties.class));
        IpsEnumType annotation = enumTypeClass.getAnnotation(IpsEnumType.class);
        this.attributeNames = Arrays.asList(annotation.attributeNames());
        this.attributeModels = EnumAttribute.createFrom(this, enumTypeClass);
        this.ipsExtensibleEnum = enumTypeClass.getAnnotation(IpsExtensibleEnum.class);
        this.messagesHelper = this.createMessageHelper(enumTypeClass.getAnnotation(IpsDocumented.class), enumTypeClass.getClassLoader());
        this.enumTypeClass = enumTypeClass;
    }

    public boolean isExtensible() {
        return this.ipsExtensibleEnum != null;
    }

    public String getEnumContentQualifiedName() {
        return this.isExtensible() ? this.ipsExtensibleEnum.enumContentName() : null;
    }

    public List<EnumAttribute> getAttributes() {
        return new ArrayList<EnumAttribute>(this.attributeModels.values());
    }

    public EnumAttribute getAttribute(String name) {
        return this.attributeModels.get(name);
    }

    public List<String> getAttributenames() {
        return this.attributeNames;
    }

    public EnumAttribute getIdAttribute() {
        return this.findMarkedAttribute("Identifier", new AttributeMatcher(){

            @Override
            public boolean matches(EnumAttribute attributeModel) {
                return attributeModel.isIdentifier();
            }
        });
    }

    public EnumAttribute getDisplayNameAttribute() {
        return this.findMarkedAttribute("DisplayName", new AttributeMatcher(){

            @Override
            public boolean matches(EnumAttribute attributeModel) {
                return attributeModel.isDisplayName();
            }
        });
    }

    private EnumAttribute findMarkedAttribute(String marker, AttributeMatcher matcher) {
        for (EnumAttribute attributeModel : this.attributeModels.values()) {
            if (!matcher.matches(attributeModel)) continue;
            return attributeModel;
        }
        throw new IllegalStateException("No attribute of the enum \"" + this.getName() + "\" is marked as " + marker);
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.messagesHelper;
    }

    @Override
    protected String getMessageKey(DocumentationKind messageType) {
        return messageType.getKey(this.getName(), KIND_NAME, "");
    }

    public Class<?> getEnumClass() {
        return this.enumTypeClass;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isExtensible()) {
            sb.append('[');
            sb.append(this.getEnumContentQualifiedName());
            sb.append(']');
        }
        sb.append("(");
        boolean first = true;
        for (String attributeName : this.attributeNames) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(attributeName);
        }
        sb.append(")");
        return sb.toString();
    }

    private static interface AttributeMatcher {
        public boolean matches(EnumAttribute var1);
    }
}

