/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InternationalStringXmlReaderWriter {
    public static final String XML_TAG = "InternationalString";
    public static final String XML_ELEMENT_LOCALIZED_STRING = "LocalizedString";
    public static final String XML_ATTR_DEFAULT_LOCALE = "defaultLocale";
    public static final String XML_ATTR_LOCALE = "locale";
    public static final String XML_ATTR_TEXT = "text";

    private InternationalStringXmlReaderWriter() {
    }

    public static Element toXml(Document doc, DefaultInternationalString internationalString) {
        Element element = InternationalStringXmlReaderWriter.toXml(doc, internationalString.getLocalizedStrings());
        element.setAttribute(XML_ATTR_DEFAULT_LOCALE, internationalString.getDefaultLocale().getLanguage());
        return element;
    }

    public static Element toXml(Document doc, Collection<LocalizedString> localizedStrings) {
        Element element = doc.createElement(XML_TAG);
        for (LocalizedString localizedString : localizedStrings) {
            if (localizedString.getValue() == null) continue;
            Element partElement = doc.createElement(XML_ELEMENT_LOCALIZED_STRING);
            Locale locale = localizedString.getLocale();
            partElement.setAttribute(XML_ATTR_LOCALE, locale.toString());
            partElement.setAttribute(XML_ATTR_TEXT, localizedString.getValue());
            element.appendChild(partElement);
        }
        return element;
    }

    public static Collection<LocalizedString> fromXml(Element element) {
        ArrayList<LocalizedString> localizedStrings = new ArrayList<LocalizedString>();
        if (!element.getNodeName().equals(XML_TAG)) {
            return localizedStrings;
        }
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element partEl;
            Node item = nl.item(i);
            if (item.getNodeType() == 1 && (partEl = (Element)item).getNodeName().equals(XML_ELEMENT_LOCALIZED_STRING)) {
                String localeString = partEl.getAttribute(XML_ATTR_LOCALE);
                Locale locale = new Locale(localeString);
                String value = partEl.getAttribute(XML_ATTR_TEXT);
                LocalizedString localizedString = new LocalizedString(locale, value);
                localizedStrings.add(localizedString);
            }
            ++i;
        }
        return localizedStrings;
    }

    public static Collection<LocalizedString> fromXml(Element element, String tagName) {
        Element internationalStringElement = InternationalStringXmlReaderWriter.getInternationalStringElement(element, tagName);
        if (internationalStringElement == null) {
            return null;
        }
        return InternationalStringXmlReaderWriter.fromXml(internationalStringElement);
    }

    public static Locale defaultLocaleFromXml(Element element, String tagName) {
        Element internationalStringElement = InternationalStringXmlReaderWriter.getInternationalStringElement(element, tagName);
        if (internationalStringElement == null) {
            return null;
        }
        return InternationalStringXmlReaderWriter.defaultLocaleFromXml(internationalStringElement);
    }

    public static Locale defaultLocaleFromXml(Element e) {
        if (!e.getNodeName().equals(XML_TAG)) {
            return null;
        }
        String defaultLocale = e.getAttribute(XML_ATTR_DEFAULT_LOCALE);
        if (IpsStringUtils.isBlank(defaultLocale)) {
            return null;
        }
        return new Locale(defaultLocale);
    }

    private static Element getInternationalStringElement(Element element, String tagName) {
        Element valueEl = XmlUtil.getFirstElement(element, tagName);
        if (valueEl == null) {
            return null;
        }
        return XmlUtil.getFirstElement(valueEl, XML_TAG);
    }

    public static void setDefaultLocaleInXml(Node node, Locale defaultLocale) {
        if (node instanceof Element) {
            ((Element)node).setAttribute(XML_ATTR_DEFAULT_LOCALE, defaultLocale.getLanguage());
        }
    }
}

