/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type.read;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.faktorips.runtime.model.type.Attribute;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.read.PartDescriptor;

public abstract class AbstractAttributeDescriptor<T extends Attribute>
extends PartDescriptor<T> {
    private AnnotatedElement annotatedElement;
    private Method setterMethod;

    public boolean isValid() {
        return this.getAnnotatedElement() instanceof Field || this.getAnnotatedElement() instanceof Method;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.annotatedElement = annotatedElement;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public void setSetterMethod(Method setterMethod) {
        this.setterMethod = setterMethod;
    }

    @Override
    public T create(ModelElement parentElement) {
        Attribute attribute;
        Type type = (Type)parentElement;
        if (this.isValid()) {
            return this.createValid(type);
        }
        Type superType = type.getSuperType();
        if (superType != null && (attribute = superType.getAttribute(this.getName())) != null) {
            Attribute overwritingAttribute = attribute.createOverwritingAttributeFor(type);
            return (T)overwritingAttribute;
        }
        throw new IllegalArgumentException(type.getDeclarationClass() + " lists \"" + this.getName() + "\" as one of it's @IpsAttributes but no matching @IpsAttribute could be found.");
    }

    protected abstract T createValid(Type var1);
}

