/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.faktorips.runtime.IEnumValueLookupService;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepositoryLookup;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.ProductCmptGenerationNotFoundException;
import org.faktorips.runtime.ProductCmptNotFoundException;
import org.faktorips.runtime.formula.IFormulaEvaluatorFactory;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.jaxb.IpsJAXBContext;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.runtime.test.IpsTestSuite;

public abstract class AbstractRuntimeRepository
implements IRuntimeRepository {
    private static final String ROOTIPSTESTSUITENAME = "ipstest";
    private static final ConcurrentHashMap<Class<?>, List<?>> ENUMVALUECACHE = new ConcurrentHashMap();
    private String name;
    private List<IRuntimeRepository> repositories = new ArrayList<IRuntimeRepository>(0);
    private List<IRuntimeRepository> allRepositories = null;
    private Map<Class<?>, IEnumValueLookupService<?>> enumValueLookups = new ConcurrentHashMap();
    private IFormulaEvaluatorFactory formulaEvaluatorFactory;
    private IRuntimeRepositoryLookup runtimeRepositoryLookup;

    public AbstractRuntimeRepository(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public final void addDirectlyReferencedRepository(IRuntimeRepository repository) {
        if (!(repository instanceof AbstractRuntimeRepository)) {
            throw new IllegalArgumentException("AbstractRuntimeRepository does not support Repositories not derived from AbstractRuntimeRepository!");
        }
        this.repositories.add(repository);
    }

    @Override
    public List<IRuntimeRepository> getDirectlyReferencedRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    @Override
    public List<IRuntimeRepository> getAllReferencedRepositories() {
        if (this.allRepositories != null) {
            return this.allRepositories;
        }
        ArrayList<IRuntimeRepository> result = new ArrayList<IRuntimeRepository>(this.repositories.size());
        LinkedList<IRuntimeRepository> candidates = new LinkedList<IRuntimeRepository>();
        candidates.add(this);
        while (!candidates.isEmpty()) {
            IRuntimeRepository candidate = (IRuntimeRepository)candidates.get(0);
            candidates.remove(0);
            if (candidate != this && !result.contains(candidate)) {
                result.add(candidate);
            }
            for (IRuntimeRepository newCandidate : candidate.getDirectlyReferencedRepositories()) {
                candidates.add(newCandidate);
            }
        }
        this.allRepositories = Collections.unmodifiableList(result);
        return this.allRepositories;
    }

    @Override
    public final IProductComponent getProductComponent(String id) {
        IProductComponent pc = this.getProductComponentInternal(id);
        if (pc != null) {
            return pc;
        }
        for (IRuntimeRepository repository : this.repositories) {
            pc = repository.getProductComponent(id);
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    @Override
    public IProductComponent getExistingProductComponent(String id) {
        if (id == null) {
            return null;
        }
        IProductComponent pc = this.getProductComponent(id);
        if (pc == null) {
            throw new ProductCmptNotFoundException(this.name, id);
        }
        return pc;
    }

    protected abstract IProductComponent getProductComponentInternal(String var1);

    @Override
    public final IProductComponent getProductComponent(String kindId, String versionId) {
        IProductComponent pc = this.getProductComponentInternal(kindId, versionId);
        if (pc != null) {
            return pc;
        }
        for (IRuntimeRepository repository : this.repositories) {
            pc = repository.getProductComponent(kindId, versionId);
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    protected abstract IProductComponent getProductComponentInternal(String var1, String var2);

    @Override
    public final List<IProductComponent> getAllProductComponents(String kindId) {
        ArrayList<IProductComponent> result = new ArrayList<IProductComponent>();
        if (kindId == null) {
            return result;
        }
        this.getAllProductComponents(kindId, result);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.getAllProductComponents(kindId, result);
        }
        return result;
    }

    protected abstract void getAllProductComponents(String var1, List<IProductComponent> var2);

    @Override
    public IProductComponentGeneration getExistingProductComponentGeneration(String id, Calendar effectiveDate) {
        IProductComponentGeneration gen = this.getProductComponentGeneration(id, effectiveDate);
        if (gen != null) {
            return gen;
        }
        IProductComponent cmpt = this.getProductComponent(id);
        if (cmpt == null) {
            throw new ProductCmptGenerationNotFoundException(this.name, id, effectiveDate, false);
        }
        throw new ProductCmptGenerationNotFoundException(this.name, id, effectiveDate, true);
    }

    @Override
    public final IProductComponentGeneration getProductComponentGeneration(String id, Calendar effectiveDate) {
        IProductComponentGeneration pcGen = this.getProductComponentGenerationInternal(id, effectiveDate);
        if (pcGen != null) {
            DateTime validTo = pcGen.getProductComponent().getValidTo();
            if (validTo != null && validTo.toTimeInMillisecs(effectiveDate.getTimeZone()) < effectiveDate.getTimeInMillis()) {
                return null;
            }
            return pcGen;
        }
        for (IRuntimeRepository repository : this.repositories) {
            pcGen = repository.getProductComponentGeneration(id, effectiveDate);
            if (pcGen == null) continue;
            return pcGen;
        }
        return null;
    }

    protected abstract IProductComponentGeneration getProductComponentGenerationInternal(String var1, Calendar var2);

    @Override
    public final <T extends IProductComponent> List<T> getAllProductComponents(Class<T> productCmptClass) {
        ArrayList result = new ArrayList();
        this.getAllProductComponentsInternal(productCmptClass, result);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.getAllProductComponentsInternal(productCmptClass, result);
        }
        return result;
    }

    protected <T extends IProductComponent> void getAllProductComponentsInternal(Class<T> productCmptClass, List<T> result) {
        ArrayList<IProductComponent> allPCmpsOfThisRepos = new ArrayList<IProductComponent>();
        this.getAllProductComponents(allPCmpsOfThisRepos);
        for (IProductComponent productCmpt : allPCmpsOfThisRepos) {
            if (!productCmptClass.isAssignableFrom(productCmpt.getClass())) continue;
            IProductComponent castedProductCmpt = productCmpt;
            result.add(castedProductCmpt);
        }
    }

    @Override
    public final List<IProductComponent> getAllProductComponents() {
        ArrayList<IProductComponent> result = new ArrayList<IProductComponent>();
        this.getAllProductComponents(result);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.getAllProductComponents(result);
        }
        return result;
    }

    protected abstract void getAllProductComponents(List<IProductComponent> var1);

    @Override
    public final List<IProductComponentGeneration> getProductComponentGenerations(IProductComponent productCmpt) {
        ArrayList<IProductComponentGeneration> result = new ArrayList<IProductComponentGeneration>();
        this.getProductComponentGenerations(productCmpt, result);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.getProductComponentGenerations(productCmpt, result);
        }
        return result;
    }

    public abstract void getProductComponentGenerations(IProductComponent var1, List<IProductComponentGeneration> var2);

    @Override
    public final List<String> getAllProductComponentIds() {
        ArrayList<String> result = new ArrayList<String>();
        this.getAllProductComponentIds(result);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.getAllProductComponentIds(result);
        }
        return result;
    }

    protected abstract void getAllProductComponentIds(List<String> var1);

    @Override
    public List<ITable<?>> getAllTables() {
        ArrayList result = new ArrayList();
        this.getAllTables(result);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.getAllTables(result);
        }
        return result;
    }

    protected abstract void getAllTables(List<ITable<?>> var1);

    @Override
    public final <T extends ITable<?>> T getTable(Class<T> tableClass) {
        T table = this.getTableInternal(tableClass);
        if (table != null) {
            return table;
        }
        for (IRuntimeRepository repository : this.repositories) {
            table = repository.getTable(tableClass);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    protected abstract <T extends ITable<?>> T getTableInternal(Class<T> var1);

    @Override
    public ITable<?> getTable(String qualifiedTableName) {
        ITable<?> table = this.getTableInternal(qualifiedTableName);
        if (table != null) {
            return table;
        }
        for (IRuntimeRepository repository : this.repositories) {
            table = repository.getTable(qualifiedTableName);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    protected abstract ITable<?> getTableInternal(String var1);

    @Override
    public final List<IpsTest2> getAllIpsTestCases(IRuntimeRepository runtimeRepository) {
        ArrayList<IpsTest2> result = new ArrayList<IpsTest2>();
        this.getAllIpsTestCases(result, runtimeRepository);
        for (IRuntimeRepository refRuntimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)refRuntimeRepository;
            refRepository.getAllIpsTestCases(result, runtimeRepository);
        }
        return result;
    }

    @Override
    public List<IpsTest2> getIpsTestCasesStartingWith(String qNamePrefix, IRuntimeRepository runtimeRepository) {
        ArrayList<IpsTest2> result = new ArrayList<IpsTest2>();
        this.getIpsTestCasesStartingWith(qNamePrefix, result, runtimeRepository);
        for (IRuntimeRepository refRuntimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)refRuntimeRepository;
            refRepository.getIpsTestCasesStartingWith(qNamePrefix, result, runtimeRepository);
        }
        return result;
    }

    protected abstract void getAllIpsTestCases(List<IpsTest2> var1, IRuntimeRepository var2);

    protected abstract void getIpsTestCasesStartingWith(String var1, List<IpsTest2> var2, IRuntimeRepository var3);

    @Override
    public IpsTest2 getIpsTest(String qName) {
        return this.getIpsTest(qName, this);
    }

    @Override
    public IpsTest2 getIpsTest(String qName, IRuntimeRepository runtimeRepository) {
        IpsTestCaseBase test = this.getIpsTestCase(qName, runtimeRepository);
        if (test != null) {
            return test;
        }
        return this.getIpsTestSuite(qName, runtimeRepository);
    }

    @Override
    public IpsTestCaseBase getIpsTestCase(String qName) {
        return this.getIpsTestCase(qName, this);
    }

    @Override
    public IpsTestCaseBase getIpsTestCase(String qName, IRuntimeRepository runtimeRepository) {
        if (qName == null) {
            throw new NullPointerException();
        }
        IpsTestCaseBase test = this.getIpsTestCaseInternal(qName, runtimeRepository);
        if (test != null) {
            return test;
        }
        for (IRuntimeRepository repository : this.repositories) {
            test = repository.getIpsTestCase(qName, runtimeRepository);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    protected abstract IpsTestCaseBase getIpsTestCaseInternal(String var1, IRuntimeRepository var2);

    @Override
    public IpsTestSuite getIpsTestSuite(String qNamePrefix) {
        return this.getIpsTestSuite(qNamePrefix, this);
    }

    @Override
    public IpsTestSuite getIpsTestSuite(String qNamePrefix, IRuntimeRepository runtimeRepository) {
        if (qNamePrefix == null) {
            throw new NullPointerException();
        }
        ConcurrentHashMap<String, IpsTestSuite> suites = new ConcurrentHashMap<String, IpsTestSuite>();
        String suiteName = this.removeLastSegment(qNamePrefix);
        suiteName = suiteName.length() == 0 ? ROOTIPSTESTSUITENAME : suiteName;
        IpsTestSuite rootSuite = new IpsTestSuite(suiteName);
        suites.put(suiteName, rootSuite);
        List<IpsTest2> testCases = this.getIpsTestCasesStartingWith(qNamePrefix, runtimeRepository);
        Collections.sort(testCases, Comparator.comparing(IpsTest2::getQualifiedName));
        for (IpsTest2 testCase : testCases) {
            this.addTest(suites, testCase);
        }
        return rootSuite;
    }

    private void addTest(Map<String, IpsTestSuite> suites, IpsTest2 test) {
        IpsTestSuite suite = this.getTestSuite(suites, test.getQualifiedName());
        suite.addTest(test);
    }

    private IpsTestSuite getTestSuite(Map<String, IpsTestSuite> suites, String testCaseQName) {
        IpsTestSuite suite;
        String suiteQName = "";
        if (testCaseQName.indexOf(".") >= 0) {
            suiteQName = this.removeLastSegment(testCaseQName);
        }
        if (IpsStringUtils.isEmpty(suiteQName)) {
            suiteQName = ROOTIPSTESTSUITENAME;
        }
        if ((suite = suites.get(suiteQName)) == null) {
            suite = new IpsTestSuite(suiteQName);
            suites.put(suiteQName, suite);
            this.addTest(suites, suite);
        }
        return suite;
    }

    private String removeLastSegment(String qName) {
        int index = qName.lastIndexOf(46);
        if (index < 0) {
            return qName;
        }
        return qName.substring(0, index);
    }

    @Override
    public IProductComponentGeneration getNextProductComponentGeneration(IProductComponentGeneration generation) {
        if (this.equals(generation.getRepository())) {
            return this.getNextProductComponentGenerationInternal(generation);
        }
        for (IRuntimeRepository refRepository : this.getAllReferencedRepositories()) {
            if (!refRepository.equals(generation.getRepository())) continue;
            return ((AbstractRuntimeRepository)refRepository).getNextProductComponentGenerationInternal(generation);
        }
        throw new IllegalArgumentException("The provided product component generation instance is not hosted in this repository or in the referenced repositories");
    }

    protected abstract IProductComponentGeneration getNextProductComponentGenerationInternal(IProductComponentGeneration var1);

    @Override
    public int getNumberOfProductComponentGenerations(IProductComponent productCmpt) {
        if (this.equals(productCmpt.getRepository())) {
            return this.getNumberOfProductComponentGenerationsInternal(productCmpt);
        }
        for (IRuntimeRepository refRepository : this.getAllReferencedRepositories()) {
            if (!refRepository.equals(productCmpt.getRepository())) continue;
            return ((AbstractRuntimeRepository)refRepository).getNumberOfProductComponentGenerationsInternal(productCmpt);
        }
        throw new IllegalArgumentException("The provided product component generation instance is not hosted in this repository or in the referenced repositories");
    }

    protected abstract int getNumberOfProductComponentGenerationsInternal(IProductComponent var1);

    @Override
    public final IProductComponentGeneration getPreviousProductComponentGeneration(IProductComponentGeneration generation) {
        if (this.equals(generation.getRepository())) {
            return this.getPreviousProductComponentGenerationInternal(generation);
        }
        for (IRuntimeRepository refRepository : this.getAllReferencedRepositories()) {
            if (!refRepository.equals(generation.getRepository())) continue;
            return ((AbstractRuntimeRepository)refRepository).getPreviousProductComponentGenerationInternal(generation);
        }
        throw new IllegalArgumentException("The provided product component generation instance is not hosted in this repository or in the referenced repositories");
    }

    protected abstract IProductComponentGeneration getPreviousProductComponentGenerationInternal(IProductComponentGeneration var1);

    @Override
    public final IProductComponentGeneration getLatestProductComponentGeneration(IProductComponent productCmpt) {
        if (this.equals(productCmpt.getRepository())) {
            return this.getLatestProductComponentGenerationInternal(productCmpt);
        }
        for (IRuntimeRepository refRepository : this.getAllReferencedRepositories()) {
            if (!refRepository.equals(productCmpt.getRepository())) continue;
            return ((AbstractRuntimeRepository)refRepository).getLatestProductComponentGenerationInternal(productCmpt);
        }
        throw new IllegalArgumentException("The provided product component generation instance is not hosted in this repository or in the referenced repositories");
    }

    protected abstract IProductComponentGeneration getLatestProductComponentGenerationInternal(IProductComponent var1);

    @Override
    public Type getModelType(Class<?> modelObjectClass) {
        return IpsModel.getType(modelObjectClass);
    }

    @Override
    public PolicyCmptType getModelType(IModelObject modelObject) {
        return IpsModel.getPolicyCmptType(modelObject);
    }

    @Override
    public ProductCmptType getModelType(IProductComponent productComponent) {
        return IpsModel.getProductCmptType(productComponent);
    }

    @Override
    public final Set<String> getAllModelTypeImplementationClasses() {
        HashSet<String> result = new HashSet<String>();
        this.getAllModelTypeImplementationClasses(result);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.getAllModelTypeImplementationClasses(result);
        }
        return result;
    }

    protected abstract void getAllModelTypeImplementationClasses(Set<String> var1);

    @Override
    @Deprecated
    public Object getEnumValue(String uniqueId) {
        int index = uniqueId.indexOf(35);
        if (index == -1) {
            return null;
        }
        String className = uniqueId.substring(0, index);
        String id = uniqueId.substring(index + 1);
        try {
            Class<?> clazz = this.getClassLoader().loadClass(className);
            return this.getEnumValue(clazz, id);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final <T> T getEnumValue(Class<T> clazz, Object id) {
        if (id == null) {
            return null;
        }
        IEnumValueLookupService<T> lookup = this.getEnumValueLookupService(clazz);
        if (lookup != null) {
            return lookup.getEnumValue(id);
        }
        List<T> enumValues = this.getEnumValues(clazz);
        try {
            Method enumValueIdMethod = clazz.getDeclaredMethod("getEnumValueId", new Class[0]);
            enumValueIdMethod.setAccessible(true);
            for (T enumValue : enumValues) {
                Object idValue = enumValueIdMethod.invoke(enumValue, new Object[0]);
                if (!id.equals(idValue)) continue;
                return enumValue;
            }
        }
        catch (SecurityException e) {
            this.throwUnableToCallMethodException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The provided enumeration class doesn't provide an identifying method getEnumValueId.", e);
        }
        catch (IllegalAccessException e) {
            this.throwUnableToCallMethodException(e);
        }
        catch (InvocationTargetException e) {
            this.throwUnableToCallMethodException(e);
        }
        return null;
    }

    @Override
    public final <T> T getExistingEnumValue(Class<T> clazz, Object id) {
        if (id == null) {
            return null;
        }
        T result = this.getEnumValue(clazz, id);
        if (result == null) {
            throw new IllegalArgumentException("No enum value of type " + clazz.getName() + " found for " + id);
        }
        return result;
    }

    private void throwUnableToCallMethodException(Exception e) {
        throw new IllegalStateException("Unable to call the getEnumValueId of the provided enumeration value.", e);
    }

    @Override
    public final <T> List<T> getEnumValues(Class<T> clazz) {
        return Collections.unmodifiableList(this.getEnumValuesOriginal(clazz));
    }

    private <T> List<T> getEnumValuesOriginal(Class<T> clazz) {
        IEnumValueLookupService<T> lookup = this.getEnumValueLookupService(clazz);
        if (lookup != null) {
            return lookup.getEnumValues();
        }
        List<T> valuesFromType = this.getEnumValuesDefinedInType(clazz);
        ArrayList<T> allValues = new ArrayList<T>(valuesFromType);
        List<T> values = this.getEnumValuesInternal(clazz);
        if (values != null) {
            allValues.addAll(values);
        } else {
            for (IRuntimeRepository repository : this.repositories) {
                List<T> referencedValues = repository.getEnumValues(clazz);
                if (referencedValues.equals(valuesFromType)) continue;
                return referencedValues;
            }
        }
        return allValues;
    }

    protected abstract <T> List<T> getEnumValuesInternal(Class<T> var1);

    protected <T> List<T> getEnumValuesDefinedInType(Class<T> enumClass) {
        if (ENUMVALUECACHE.containsKey(enumClass)) {
            return this.getCachedEnumValuesDefinedInType(enumClass);
        }
        return this.getEnumValuesDefinedInTypeByReflection(enumClass);
    }

    private <T> List<T> getCachedEnumValuesDefinedInType(Class<T> enumClass) {
        List<?> values = ENUMVALUECACHE.get(enumClass);
        return values;
    }

    private <T> List<T> getEnumValuesDefinedInTypeByReflection(Class<T> enumClass) {
        if (enumClass.isEnum()) {
            return Arrays.asList(enumClass.getEnumConstants());
        }
        try {
            Field valuesField = enumClass.getDeclaredField("VALUES");
            List values = (List)valuesField.get(null);
            List previousValues = ENUMVALUECACHE.putIfAbsent(enumClass, values);
            if (previousValues != null) {
                List castedPreviousValues = previousValues;
                return castedPreviousValues;
            }
            return values;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            ENUMVALUECACHE.putIfAbsent(enumClass, Collections.emptyList());
            return Collections.emptyList();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addEnumValueLookupService(IEnumValueLookupService<?> lookup) {
        this.enumValueLookups.put(lookup.getEnumTypeClass(), lookup);
    }

    @Override
    public <T> IEnumValueLookupService<T> getEnumValueLookupService(Class<T> enumClazz) {
        IEnumValueLookupService<Object> enumValueLookupService = this.enumValueLookups.get(enumClazz);
        if (enumValueLookupService == null) {
            for (IRuntimeRepository repository : this.getAllReferencedRepositories()) {
                enumValueLookupService = repository.getEnumValueLookupService(enumClazz);
                if (enumValueLookupService != null) break;
            }
        }
        return enumValueLookupService;
    }

    @Override
    public void removeEnumValueLookupService(IEnumValueLookupService<?> lookup) {
        this.enumValueLookups.remove(lookup.getEnumTypeClass());
    }

    protected abstract List<XmlAdapter<?, ?>> getAllInternalEnumXmlAdapters(IRuntimeRepository var1);

    private void addAllEnumXmlAdapters(List<XmlAdapter<?, ?>> adapters, IRuntimeRepository repository) {
        adapters.addAll(this.getAllInternalEnumXmlAdapters(repository));
        for (IEnumValueLookupService<?> lookupService : this.enumValueLookups.values()) {
            XmlAdapter<?, ?> adapter = lookupService.getXmlAdapter();
            if (adapter == null) continue;
            adapters.add(adapter);
        }
    }

    @Override
    public final List<Class<?>> getAllEnumClasses() {
        LinkedHashSet result = new LinkedHashSet();
        this.getAllEnumClasses(result);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.getAllEnumClasses(result);
        }
        return new ArrayList(result);
    }

    protected abstract void getAllEnumClasses(LinkedHashSet<Class<?>> var1);

    public JAXBContext newJAXBContext(JAXBContext ctx) {
        LinkedList adapters = new LinkedList();
        this.addAllEnumXmlAdapters(adapters, this);
        for (IRuntimeRepository runtimeRepository : this.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.addAllEnumXmlAdapters(adapters, this);
        }
        return new IpsJAXBContext(ctx, adapters, this);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JAXBContext newJAXBContext() {
        JAXBContext jAXBContext;
        block8: {
            ClassLoader tccl = null;
            try {
                Set<String> classNames = this.getAllModelTypeImplementationClasses();
                LinkedHashSet classes = new LinkedHashSet(classNames.size());
                Iterator<String> iterator = classNames.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        tccl = this.getPrivilegedCurrentThreadContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClassLoader());
                        JAXBContext ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
                        jAXBContext = this.newJAXBContext(ctx);
                        if (tccl == null) break block8;
                        break;
                    }
                    String className = iterator.next();
                    Class<?> clazz = this.getClassLoader().loadClass(className);
                    if (!this.isAnnotatedXmlRootElement(clazz)) continue;
                    classes.add(clazz);
                }
            }
            catch (RuntimeException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (tccl != null) {
                        Thread.currentThread().setContextClassLoader(tccl);
                    }
                    throw throwable;
                }
            }
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return jAXBContext;
    }

    private ClassLoader getPrivilegedCurrentThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(Thread.currentThread()::getContextClassLoader);
    }

    private boolean isAnnotatedXmlRootElement(Class<?> clazz) {
        Class<?> c = clazz;
        while (c != null) {
            if (c.isAnnotationPresent(XmlRootElement.class)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    @Override
    public IFormulaEvaluatorFactory getFormulaEvaluatorFactory() {
        return this.formulaEvaluatorFactory;
    }

    public void setFormulaEvaluatorFactory(IFormulaEvaluatorFactory formulaEvaluatorFactory) {
        this.formulaEvaluatorFactory = formulaEvaluatorFactory;
    }

    @Override
    public <T> T getCustomRuntimeObject(Class<T> type, String ipsObjectQualifiedName) {
        T pc = this.getCustomRuntimeObjectInternal(type, ipsObjectQualifiedName);
        if (pc != null) {
            return pc;
        }
        for (IRuntimeRepository repository : this.repositories) {
            pc = repository.getCustomRuntimeObject(type, ipsObjectQualifiedName);
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    protected abstract <T> T getCustomRuntimeObjectInternal(Class<T> var1, String var2);

    @Override
    public IRuntimeRepositoryLookup getRuntimeRepositoryLookup() {
        return this.runtimeRepositoryLookup;
    }

    @Override
    public void setRuntimeRepositoryLookup(IRuntimeRepositoryLookup repositoryLookup) {
        this.runtimeRepositoryLookup = repositoryLookup;
    }
}

