/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

enum ProductComponentXmlUtil {

    static final String XML_TAG_FORMULA = "Formula";
    static final String XML_TAG_EXPRESSION = "Expression";
    static final String XML_ATTRIBUTE_FORMULA_SIGNATURE = "formulaSignature";

    static final Map<String, List<Element>> getLinkElements(Element genElement) {
        HashMap<String, List<Element>> elementMap = new HashMap<String, List<Element>>();
        NodeList nl = genElement.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && "Link".equals(node.getNodeName())) {
                Element childElement = (Element)nl.item(i);
                String association = childElement.getAttribute("association");
                List associationElements = elementMap.computeIfAbsent(association, $ -> new ArrayList(1));
                associationElements.add(childElement);
            }
            ++i;
        }
        return elementMap;
    }

    static final Map<String, Element> getPropertyElements(Element element) {
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                Element childElement = (Element)node;
                String attributeName = childElement.getAttribute("attribute");
                if ("ConfiguredDefault".equals(node.getNodeName())) {
                    elementMap.put("@default_" + attributeName, childElement);
                } else if ("ConfiguredValueSet".equals(node.getNodeName())) {
                    elementMap.put("@valueSet_" + attributeName, childElement);
                } else if ("AttributeValue".equals(node.getNodeName())) {
                    elementMap.put(attributeName, childElement);
                } else if ("TableContentUsage".equals(node.getNodeName())) {
                    String structureUsage = childElement.getAttribute("structureUsage");
                    elementMap.put(structureUsage, childElement);
                }
            }
            ++i;
        }
        return elementMap;
    }

    static final Map<String, String> getAvailableFormulars(Element element) {
        LinkedHashMap<String, String> availableFormulas = new LinkedHashMap<String, String>();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                Element aFormula = (Element)node;
                if (XML_TAG_FORMULA.equals(node.getNodeName())) {
                    String name = aFormula.getAttribute(XML_ATTRIBUTE_FORMULA_SIGNATURE);
                    NodeList nodeList = aFormula.getElementsByTagName(XML_TAG_EXPRESSION);
                    Element expressionElement = (Element)nodeList.item(0);
                    String content = expressionElement.getTextContent();
                    availableFormulas.put(name, content.trim());
                }
            }
            ++i;
        }
        return availableFormulas;
    }
}

