/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.delta;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.faktorips.runtime.IDeltaComputationOptions;
import org.faktorips.runtime.IDeltaSupport;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IModelObjectDelta;
import org.faktorips.runtime.internal.ModelObjectDelta;
import org.faktorips.runtime.model.type.AssociationKind;

public class ChildDeltaCreator {
    private final String association;
    private final IDeltaComputationOptions options;
    private final AssociationKind kind;

    @Deprecated
    public ChildDeltaCreator(String association, IDeltaComputationOptions options) {
        this(association, AssociationKind.Composition, options);
    }

    public ChildDeltaCreator(String association, AssociationKind kind, IDeltaComputationOptions options) {
        this.association = association;
        this.kind = kind;
        this.options = AssociationKind.Association == kind ? ChildDeltaCreator.withoutSubtrees(options) : options;
    }

    public void createChildDeltas(ModelObjectDelta delta, IModelObject original, IModelObject refObject) {
        this.createChildDeltas(delta, ChildDeltaCreator.listOf(original), ChildDeltaCreator.listOf(refObject));
    }

    private static List<IModelObject> listOf(IModelObject item) {
        if (item != null) {
            return Collections.singletonList(item);
        }
        return Collections.emptyList();
    }

    public void createChildDeltas(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects) {
        if (delta == null) {
            return;
        }
        if (this.options.getMethod(this.association) == IDeltaComputationOptions.ComputationMethod.BY_POSITION) {
            this.createChildDeltasPerPosition(delta, originals, refObjects);
        } else if (this.options.getMethod(this.association) == IDeltaComputationOptions.ComputationMethod.BY_OBJECT) {
            this.createChildDeltasPerObject(delta, originals, refObjects);
        } else {
            throw new RuntimeException("Unknown delta computation method " + (Object)((Object)this.options.getMethod(this.association)));
        }
    }

    private void createChildDeltasPerPosition(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects) {
        int max = Math.max(originals.size(), refObjects.size());
        int i = 0;
        while (i < max) {
            if (this.hasObject(originals, i)) {
                IModelObject original = originals.get(i);
                if (this.hasObject(refObjects, i)) {
                    IModelObject refObject = refObjects.get(i);
                    if (this.options.isSame(original, refObject)) {
                        if (this.kind == AssociationKind.Composition) {
                            IModelObjectDelta childDelta = ((IDeltaSupport)((Object)original)).computeDelta(refObject, this.options);
                            this.updateAssociationInfo(childDelta);
                            delta.addChildDelta(childDelta);
                        }
                    } else {
                        delta.addChildDelta(ModelObjectDelta.newDifferentObjectAtPositionChangedDelta(original, refObject, this.association, this.kind));
                    }
                } else {
                    delta.addChildDelta(ModelObjectDelta.newRemoveDelta(original, this.association, this.kind, this.options));
                }
            } else if (this.hasObject(refObjects, i)) {
                delta.addChildDelta(ModelObjectDelta.newAddDelta(refObjects.get(i), this.association, this.kind, this.options));
            } else {
                throw new RuntimeException("Error in delta computation. Both objects null in assocation " + this.association);
            }
            ++i;
        }
    }

    private <T> boolean hasObject(Collection<T> collection, int index) {
        return index < collection.size();
    }

    private void createChildDeltasPerObject(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects) {
        int removeCounter = 0;
        int size = originals.size();
        int i = 0;
        while (i < size) {
            IModelObjectDelta childDelta = this.createRemoveMoveOrChangeDelta(originals.get(i), i, refObjects);
            this.updateAssociationInfo(childDelta);
            delta.addChildDelta(childDelta);
            if (childDelta.isRemoved()) {
                ++removeCounter;
            }
            ++i;
        }
        int refSize = refObjects.size();
        if (size - removeCounter == refSize) {
            return;
        }
        int i2 = 0;
        while (i2 < refSize) {
            boolean exists = false;
            int j = 0;
            while (j < size) {
                if (this.options.isSame(originals.get(j), refObjects.get(i2))) {
                    exists = true;
                    break;
                }
                ++j;
            }
            if (!exists) {
                delta.addChildDelta(ModelObjectDelta.newAddDelta(refObjects.get(i2), this.association, this.kind, this.options));
            }
            ++i2;
        }
    }

    private void updateAssociationInfo(IModelObjectDelta childDelta) {
        ((ModelObjectDelta)childDelta).setAssociation(this.association);
        ((ModelObjectDelta)childDelta).setAssociationKind(this.kind);
    }

    private final IModelObjectDelta createRemoveMoveOrChangeDelta(IModelObject original, int position, List<? extends IModelObject> refObjects) {
        int refSize = refObjects.size();
        if (position < refSize && this.options.isSame(original, refObjects.get(position))) {
            IModelObject refObject = refObjects.get(position);
            if (this.kind == AssociationKind.Composition) {
                return ((IDeltaSupport)((Object)original)).computeDelta(refObject, this.options);
            }
            return ModelObjectDelta.newEmptyDelta(original, refObject);
        }
        int i = 0;
        while (i < refSize) {
            IModelObject refObject;
            if (i != position && this.options.isSame(original, refObject = refObjects.get(i))) {
                if (this.kind == AssociationKind.Composition) {
                    IModelObjectDelta childDelta = ((IDeltaSupport)((Object)original)).computeDelta(refObject, this.options);
                    ((ModelObjectDelta)childDelta).markMoved();
                    return childDelta;
                }
                ModelObjectDelta delta = ModelObjectDelta.newEmptyDelta(original, refObject);
                delta.markMoved();
                return delta;
            }
            ++i;
        }
        return ModelObjectDelta.newRemoveDelta(original, this.association, this.kind, this.options);
    }

    private static IDeltaComputationOptions withoutSubtrees(IDeltaComputationOptions options) {
        return new DeltaComputationOptionsWithoutSubtrees(options);
    }

    private static final class DeltaComputationOptionsWithoutSubtrees
    implements IDeltaComputationOptions {
        private final IDeltaComputationOptions options;

        private DeltaComputationOptionsWithoutSubtrees(IDeltaComputationOptions options) {
            this.options = options;
        }

        @Override
        public boolean isSame(IModelObject object1, IModelObject object2) {
            return this.options.isSame(object1, object2);
        }

        @Override
        public boolean isCreateSubtreeDelta() {
            return false;
        }

        @Override
        public boolean ignore(Class<?> clazz, String property) {
            return this.options.ignore(clazz, property);
        }

        @Override
        public IDeltaComputationOptions.ComputationMethod getMethod(String association) {
            return this.options.getMethod(association);
        }

        @Override
        public boolean areValuesEqual(Class<?> clazz, String property, Object value1, Object value2) {
            return this.options.areValuesEqual(clazz, property, value1, value2);
        }

        @Override
        public boolean ignoreAssociations() {
            return this.options.ignoreAssociations();
        }
    }
}

