/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.table;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsTableColumn;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.table.TableStructure;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.read.SimpleTypePartsReader;
import org.faktorips.runtime.util.MessagesHelper;

public class TableColumn
extends ModelElement {
    private final Class<?> datatype;
    private final Method getterMethod;
    private final TableStructure tableStructure;

    protected TableColumn(TableStructure tableStructure, String name, Class<?> datatype, Method getterMethod) {
        super(name, getterMethod.getAnnotation(IpsExtensionProperties.class));
        this.tableStructure = tableStructure;
        this.datatype = datatype;
        this.getterMethod = getterMethod;
    }

    public Class<?> getDatatype() {
        return this.datatype;
    }

    protected Method getGetterMethod() {
        return this.getterMethod;
    }

    public Object getValue(Object row) {
        try {
            return this.getGetterMethod().invoke(row, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't get value for column \"" + this.getName() + "\"", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Can't get value for column \"" + this.getName() + "\"", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Can't get value for column \"" + this.getName() + "\"", e);
        }
    }

    protected static LinkedHashMap<String, TableColumn> createModelsFrom(TableStructure tableStructure, Class<? extends ITable<?>> tableObjectClass, Class<?> tableRowClass) {
        return new SimpleTypePartsReader<TableColumn, IpsTableStructure, IpsTableColumn>(IpsTableStructure.class, IpsTableStructure::columns, IpsTableColumn.class, IpsTableColumn::name, (modelElement, name, getterMethod) -> new TableColumn((TableStructure)modelElement, name, getterMethod.getReturnType(), getterMethod)).createParts(tableObjectClass, tableRowClass, tableStructure);
    }

    @Override
    protected String getMessageKey(DocumentationKind messageType) {
        return messageType.getKey(this.tableStructure.getName(), "TableStructure", this.getName());
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.tableStructure.getMessageHelper();
    }
}

