/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.table;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.table.TableColumn;
import org.faktorips.runtime.model.table.TableStructureKind;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.util.MessagesHelper;
import org.faktorips.runtime.util.StringBuilderJoiner;

public class TableStructure
extends ModelElement {
    public static final String KIND_NAME = "TableStructure";
    private TableStructureKind kind;
    private LinkedHashMap<String, TableColumn> columnModels;
    private List<String> columnNames;
    private final MessagesHelper messagesHelper;

    public TableStructure(Class<? extends ITable<?>> tableObjectClass) {
        super(tableObjectClass.getAnnotation(IpsTableStructure.class).name(), tableObjectClass.getAnnotation(IpsExtensionProperties.class));
        IpsTableStructure annotation = tableObjectClass.getAnnotation(IpsTableStructure.class);
        this.kind = annotation.type();
        this.columnNames = Arrays.asList(annotation.columns());
        Class tableRowClass = (Class)((ParameterizedType)tableObjectClass.getGenericSuperclass()).getActualTypeArguments()[0];
        this.columnModels = TableColumn.createModelsFrom(this, tableObjectClass, tableRowClass);
        this.messagesHelper = this.createMessageHelper(tableObjectClass.getAnnotation(IpsDocumented.class), tableObjectClass.getClassLoader());
    }

    public TableStructureKind getKind() {
        return this.kind;
    }

    public List<TableColumn> getColumns() {
        return new ArrayList<TableColumn>(this.columnModels.values());
    }

    public TableColumn getColumn(String columnName) {
        return this.columnModels.get(IpsStringUtils.toLowerFirstChar(columnName));
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Object getValue(Object tableRow, TableColumn column) {
        return column.getValue(tableRow);
    }

    public Object getValue(Object tableRow, String columnName) {
        return this.getValue(tableRow, this.getColumn(columnName));
    }

    public List<Object> getValues(Object tableRow) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (TableColumn column : this.columnModels.values()) {
            values.add(this.getValue(tableRow, column));
        }
        return values;
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.messagesHelper;
    }

    @Override
    protected String getMessageKey(DocumentationKind messageType) {
        return messageType.getKey(this.getName(), KIND_NAME, "");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append((Object)this.kind);
        sb.append("(");
        StringBuilderJoiner.join(sb, this.columnNames);
        sb.append(")");
        return sb.toString();
    }
}

