/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.faktorips.runtime.IMarker;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageLists;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.util.AbstractMessageList;

public class MessageList
extends AbstractMessageList<Message, MessageList>
implements Serializable {
    private static final long serialVersionUID = 5518835977871253111L;

    public MessageList() {
    }

    public MessageList(Message message) {
        super(message);
    }

    @Override
    protected MessageList createEmptyMessageList() {
        return new MessageList();
    }

    public static final MessageList of(Message ... messages) {
        if (messages == null) {
            return new MessageList();
        }
        MessageList messageList = new MessageList();
        Message[] messageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Message message = messageArray[n2];
            messageList.add(message);
            ++n2;
        }
        return messageList;
    }

    public static final MessageList ofErrors(String ... texts) {
        if (texts == null) {
            return new MessageList();
        }
        return Stream.of(texts).map(text -> new Message((String)text, Severity.ERROR)).collect(MessageLists.collectMessages());
    }

    public static final MessageList createCopy(MessageList list, Object oldObject, Object newObject) {
        MessageList newList = new MessageList();
        for (Message message : list) {
            newList.add(Message.createCopy(message, oldObject, newObject));
        }
        return newList;
    }

    public void add(MessageList messageList, ObjectProperty invalidObjectProperty, boolean override) {
        if (messageList == null) {
            return;
        }
        for (Message message : messageList) {
            if (override || message.getInvalidObjectProperties().size() == 0) {
                this.add(new Message(message.getCode(), message.getText(), message.getSeverity(), invalidObjectProperty));
                continue;
            }
            this.add(message);
        }
    }

    public Message getFirstMessage(Severity severity) {
        for (Message message : this.getMessages()) {
            if (message.getSeverity() != severity) continue;
            return message;
        }
        return null;
    }

    @Override
    public Message getMessageWithHighestSeverity() {
        Message result = null;
        for (Message message : this.getMessages()) {
            if (result == null) {
                result = message;
                continue;
            }
            if (result.getSeverity().compareTo(message.getSeverity()) >= 0) continue;
            result = message;
        }
        return result;
    }

    public MessageList getMessagesByMarker(IMarker marker) {
        MessageList sublist = new MessageList();
        for (Message message : this.getMessages()) {
            Set<? extends IMarker> markers = message.getMarkers();
            if ((marker != null || !markers.isEmpty()) && !markers.contains(marker)) continue;
            sublist.add(message);
        }
        return sublist;
    }

    public MessageList getMessagesByMarker(Predicate<IMarker> markerPredicate) {
        if (markerPredicate == null) {
            throw new NullPointerException("markerPredicate must not be null");
        }
        MessageList sublist = new MessageList();
        block0: for (Message message : this.getMessages()) {
            for (IMarker iMarker : message.getMarkers()) {
                if (!markerPredicate.test(iMarker)) continue;
                sublist.add(message);
                continue block0;
            }
        }
        return sublist;
    }

    public Severity getSeverity() {
        Severity severity = Severity.NONE;
        for (Message message : this.getMessages()) {
            if (message.getSeverity().compareTo(severity) <= 0) continue;
            severity = message.getSeverity();
        }
        return severity;
    }

    @Override
    public boolean containsErrorMsg() {
        for (Message message : this.getMessages()) {
            if (message.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    @Override
    public MessageList getMessagesFor(Object object, String property, int index) {
        MessageList result = new MessageList();
        block0: for (Message message : this.getMessages()) {
            List<ObjectProperty> op = message.getInvalidObjectProperties();
            for (ObjectProperty objectProperty : op) {
                if (!objectProperty.getObject().equals(object)) continue;
                if (property == null) {
                    result.add(message);
                    continue block0;
                }
                if (!property.equals(objectProperty.getProperty()) || index >= 0 && objectProperty.getIndex() != index) continue;
                result.add(message);
                continue block0;
            }
        }
        return result;
    }
}

