/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.util.IMessage;

public abstract class AbstractMessageList<M extends IMessage, L extends AbstractMessageList<M, L>>
implements Iterable<M> {
    private List<M> messages = new ArrayList<M>(0);

    public AbstractMessageList() {
    }

    public AbstractMessageList(M message) {
        this.add((L)message);
    }

    public void add(M message) {
        if (message != null) {
            this.messages.add(message);
        }
    }

    public void add(L messageList) {
        if (messageList == null) {
            return;
        }
        for (IMessage message : messageList) {
            this.add((L)message);
        }
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public int size() {
        return this.messages.size();
    }

    @Deprecated
    public int getNoOfMessages() {
        return this.size();
    }

    public M getMessage(int index) {
        return (M)((IMessage)this.messages.get(index));
    }

    public List<M> getMessages() {
        return this.messages;
    }

    public void setMessages(List<M> messages) {
        this.messages = messages;
    }

    public String toString() {
        return IpsStringUtils.join(this.messages, System.lineSeparator());
    }

    public void clear() {
        this.messages.clear();
    }

    @Override
    public Iterator<M> iterator() {
        return this.messages.iterator();
    }

    public L getMessagesFor(Object object, String property) {
        return this.getMessagesFor(object, property, -1);
    }

    public L getMessagesFor(Object object) {
        return this.getMessagesFor(object, null);
    }

    public boolean equals(Object obj) {
        block7: {
            AbstractMessageList other;
            block6: {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                try {
                    other = (AbstractMessageList)obj;
                    if (this.getMessages() != null) break block6;
                    if (other.getMessages() != null) {
                        return false;
                    }
                    break block7;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
            if (this.getMessages().equals(other.getMessages())) break block7;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        return result;
    }

    public M getMessageByCode(String code) {
        for (IMessage message : this.getMessages()) {
            if (!Objects.equals(message.getCode(), code)) continue;
            return (M)message;
        }
        return null;
    }

    public L getMessagesByCode(String code) {
        IMessage sublist = this.createEmptyMessageList();
        for (IMessage message : this.getMessages()) {
            if (!Objects.equals(message.getCode(), code)) continue;
            ((AbstractMessageList)((Object)sublist)).add((L)message);
        }
        return (L)sublist;
    }

    public String getText() {
        return IpsStringUtils.join(this.getMessages(), IMessage::getText, System.lineSeparator());
    }

    public abstract boolean containsErrorMsg();

    public abstract M getMessageWithHighestSeverity();

    public abstract L getMessagesFor(Object var1, String var2, int var3);

    protected abstract L createEmptyMessageList();

    @Override
    public Spliterator<M> spliterator() {
        return this.messages.spliterator();
    }

    public Stream<M> stream() {
        return this.messages.stream();
    }

    public Stream<M> parallelStream() {
        return this.messages.parallelStream();
    }
}

