/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.validation;

import java.util.Objects;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.validation.IGenericAttributeValidationConfiguration;
import org.faktorips.runtime.validation.Relevance;
import org.faktorips.values.ObjectUtil;
import org.faktorips.valueset.ValueSet;

public class GenericRelevanceValidation {
    private final IModelObject modelObject;
    private final PolicyAttribute policyAttribute;
    private final IGenericAttributeValidationConfiguration config;

    public GenericRelevanceValidation(IModelObject modelObject, PolicyAttribute policyAttribute, IGenericAttributeValidationConfiguration config) {
        this.modelObject = Objects.requireNonNull(modelObject, "modelObject must not be null");
        this.policyAttribute = Objects.requireNonNull(policyAttribute, "policyAttribute must not be null");
        this.config = Objects.requireNonNull(config, "config must not be null");
    }

    public static MessageList of(IModelObject modelObject, String propertyName, IValidationContext validationContext) {
        return new GenericRelevanceValidation(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(propertyName), validationContext.getGenericAttributeValidationConfiguration()).validate();
    }

    public MessageList validate() {
        MessageList messages = new MessageList();
        messages.add(this.validateValuePresentIfMandatory());
        messages.add(this.validateValueNullIfIrrelevant());
        messages.add(this.validateValueContainedIfPresent());
        return messages;
    }

    private Message validateValuePresentIfMandatory() {
        if (this.isInvalidMandatory()) {
            return this.config.createMessageForMissingMandatoryValue(this.policyAttribute, this.modelObject);
        }
        return null;
    }

    private Message validateValueNullIfIrrelevant() {
        if (this.isInvalidIrrelevance()) {
            return this.config.createMessageForValuePresentForIgnoredAttribute(this.policyAttribute, this.modelObject);
        }
        return null;
    }

    private Message validateValueContainedIfPresent() {
        if (this.isInvalidNotContained()) {
            return this.config.createMessageForValueNotInAllowedValueSet(this.policyAttribute, this.modelObject);
        }
        return null;
    }

    private boolean isInvalidMandatory() {
        return !this.isValuePresent() && Relevance.isMandatory(this.modelObject, this.policyAttribute);
    }

    private boolean isInvalidIrrelevance() {
        return this.isValuePresent() && Relevance.isIrrelevant(this.modelObject, this.policyAttribute);
    }

    private boolean isInvalidNotContained() {
        ValueSet valueSet = this.getValueSet();
        return Relevance.isRelevant(this.modelObject, this.policyAttribute) && this.isValuePresent() && valueSet != null && !valueSet.contains(this.getValue());
    }

    private boolean isValuePresent() {
        Object value = this.policyAttribute.getValue(this.modelObject);
        return !ObjectUtil.isNull((Object)value) && (!(value instanceof CharSequence) || !IpsStringUtils.isBlank(((CharSequence)value).toString()));
    }

    private Object getValue() {
        return this.policyAttribute.getValue(this.modelObject);
    }

    private <T> ValueSet<T> getValueSet() {
        return this.policyAttribute.getValueSet(this.modelObject);
    }
}

