/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.faktorips.runtime.internal.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class IpsTestCase
extends TestCase {
    public IpsTestCase(String name) {
        super(name);
    }

    protected void runTest() throws Throwable {
        Document doc = this.getXmlDocument(this.getName());
        if (doc == null && this.getName().startsWith("test")) {
            doc = this.getXmlDocument(this.getName().substring(4));
        }
        if (doc == null) {
            throw new RuntimeException("Can't find resource for test case " + this.getName());
        }
        this.run(doc);
    }

    private Document getXmlDocument(String name) throws SAXException, IOException, ParserConfigurationException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(String.valueOf(name) + ".xml");
        if (is == null && (is = ((Object)((Object)this)).getClass().getResourceAsStream(String.valueOf(name) + ".ipstestcase")) == null) {
            return null;
        }
        return this.getDocumentBuilder().parse(is);
    }

    protected void run(Document doc) throws Exception {
        this.run(doc.getDocumentElement());
    }

    protected void run(Element testCaseEl) throws Exception {
        this.readInput(XmlUtil.getFirstElement(testCaseEl));
        this.execBusinessFcts();
        this.readExpectedResult(XmlUtil.getFirstElement(testCaseEl, "ExpectedResult"));
        this.execAsserts();
    }

    protected abstract void readInput(Element var1);

    protected abstract void readExpectedResult(Element var1);

    protected abstract void execBusinessFcts() throws Exception;

    protected abstract void execAsserts() throws Exception;

    protected DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        return builder;
    }
}

