/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/

package org.faktorips.runtime;

import java.util.Locale;

import org.faktorips.runtime.validation.DefaultGenericAttributeValidationConfiguration;
import org.faktorips.runtime.validation.IGenericAttributeValidationConfiguration;

/**
 * A validation context is provided to the validate() method generated by Faktor-IPS. By means of
 * the validation context the caller can provide additional information to the validate method like
 * for example the business context in which the validation is to execute.
 */
public interface IValidationContext {

    /**
     * Returns the Locale that is to use for the creation of validation messages.
     */
    Locale getLocale();

    /**
     * Returns the value for property with the specified name.
     */
    Object getValue(String propertyName);

    /**
     * Returns the configuration for generic attribute validation.
     *
     * @implSpec Implementers should overwrite this method to return their own implementation with
     *           custom error messages.
     * @implNote The default implementation always creates a new
     *           {@link DefaultGenericAttributeValidationConfiguration}.
     * @since 21.6
     */
    default IGenericAttributeValidationConfiguration getGenericAttributeValidationConfiguration() {
        return new DefaultGenericAttributeValidationConfiguration(getLocale());
    }
}
