/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.faktorips.runtime.IMarker;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageLists;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;

public class MessageList
implements Serializable,
Iterable<Message> {
    private static final long serialVersionUID = 5518835977871253111L;
    private List<Message> messages = new ArrayList<Message>(0);

    public MessageList() {
    }

    public MessageList(Message message) {
        this.add(message);
    }

    protected MessageList createEmptyMessageList() {
        return new MessageList();
    }

    public static final MessageList of(Message ... messages) {
        if (messages == null) {
            return new MessageList();
        }
        MessageList messageList = new MessageList();
        Message[] messageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Message message = messageArray[n2];
            messageList.add(message);
            ++n2;
        }
        return messageList;
    }

    public static final MessageList ofErrors(String ... texts) {
        if (texts == null) {
            return new MessageList();
        }
        return Stream.of(texts).map((? super T text) -> new Message((String)text, Severity.ERROR)).collect(MessageLists.collectMessages());
    }

    public static final MessageList createCopy(MessageList list, Object oldObject, Object newObject) {
        MessageList newList = new MessageList();
        for (Message message : list) {
            newList.add(Message.createCopy(message, oldObject, newObject));
        }
        return newList;
    }

    public static final MessageList createCopy(MessageList list, Map<ObjectProperty, ObjectProperty> objectPropertyMap) {
        MessageList newList = new MessageList();
        for (Message message : list) {
            newList.add(Message.createCopy(message, objectPropertyMap));
        }
        return newList;
    }

    public void add(Message message) {
        if (message != null) {
            this.messages.add(message);
        }
    }

    public void add(MessageList messageList) {
        if (messageList == null) {
            return;
        }
        for (Message message : messageList) {
            this.add(message);
        }
    }

    public void add(MessageList messageList, ObjectProperty invalidObjectProperty, boolean override) {
        if (messageList == null) {
            return;
        }
        for (Message message : messageList) {
            if (override || message.getInvalidObjectProperties().size() == 0) {
                this.add(new Message(message.getCode(), message.getText(), message.getSeverity(), invalidObjectProperty));
                continue;
            }
            this.add(message);
        }
    }

    public Message newError(String code, String text, Object invalidObject, String ... invalidProperties) {
        Message newError = Message.newError(code, text, invalidObject, invalidProperties);
        this.add(newError);
        return newError;
    }

    public Message newError(String code, String text, ObjectProperty ... invalidObjectProperty) {
        Message newError = Message.newError(code, text, invalidObjectProperty);
        this.add(newError);
        return newError;
    }

    public Message newWarning(String code, String text, Object invalidObject, String ... invalidProperties) {
        Message newWarning = Message.newWarning(code, text, invalidObject, invalidProperties);
        this.add(newWarning);
        return newWarning;
    }

    public Message newInfo(String code, String text, Object invalidObject, String invalidProperty) {
        Message newInfo = Message.newInfo(code, text, invalidObject, invalidProperty);
        this.add(newInfo);
        return newInfo;
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public int size() {
        return this.messages.size();
    }

    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    @Deprecated
    public int getNoOfMessages() {
        return this.size();
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public Message getFirstMessage(Severity severity) {
        for (Message message : this.getMessages()) {
            if (message.getSeverity() != severity) continue;
            return message;
        }
        return null;
    }

    public Message getMessageWithHighestSeverity() {
        Message result = null;
        for (Message message : this.getMessages()) {
            if (result == null) {
                result = message;
                continue;
            }
            if (result.getSeverity().compareTo(message.getSeverity()) >= 0) continue;
            result = message;
        }
        return result;
    }

    public Message getMessageByCode(String code) {
        for (Message message : this.getMessages()) {
            if (!Objects.equals(message.getCode(), code)) continue;
            return message;
        }
        return null;
    }

    public MessageList getMessagesByCode(String code) {
        MessageList sublist = this.createEmptyMessageList();
        for (Message message : this.getMessages()) {
            if (!Objects.equals(message.getCode(), code)) continue;
            sublist.add(message);
        }
        return sublist;
    }

    public MessageList getMessagesBySeverity(Severity severity) {
        MessageList messageList = this.createEmptyMessageList();
        for (Message message : this.getMessages()) {
            if (message.getSeverity() != severity) continue;
            messageList.add(message);
        }
        return messageList;
    }

    public int getNoOfMessages(Severity severity) {
        ArrayList<Message> msgList = new ArrayList<Message>(this.getMessages().size());
        for (Message msg : this.getMessages()) {
            if (msg.getSeverity() != severity) continue;
            msgList.add(msg);
        }
        return msgList.size();
    }

    public MessageList getSubList(int maxCount) {
        MessageList sortedSubList = MessageLists.sortBySeverity(this);
        sortedSubList.setMessages(sortedSubList.getMessages().subList(0, Math.min(maxCount, this.size())));
        return sortedSubList;
    }

    public MessageList getMessagesByMarker(IMarker marker) {
        MessageList sublist = new MessageList();
        for (Message message : this.getMessages()) {
            Set<? extends IMarker> markers = message.getMarkers();
            if ((marker != null || !markers.isEmpty()) && !markers.contains(marker)) continue;
            sublist.add(message);
        }
        return sublist;
    }

    public MessageList getMessagesByMarker(Predicate<IMarker> markerPredicate) {
        if (markerPredicate == null) {
            throw new NullPointerException("markerPredicate must not be null");
        }
        MessageList sublist = new MessageList();
        block0: for (Message message : this.getMessages()) {
            for (IMarker iMarker : message.getMarkers()) {
                if (!markerPredicate.test(iMarker)) continue;
                sublist.add(message);
                continue block0;
            }
        }
        return sublist;
    }

    public Severity getSeverity() {
        Severity severity = Severity.NONE;
        for (Message message : this.getMessages()) {
            if (message.getSeverity().compareTo(severity) <= 0) continue;
            severity = message.getSeverity();
        }
        return severity;
    }

    public String getText() {
        return IpsStringUtils.join(this.getMessages(), Message::getText, System.lineSeparator());
    }

    public void remove(Message message) {
        this.getMessages().remove(message);
    }

    public boolean containsErrorMsg() {
        for (Message message : this.getMessages()) {
            if (message.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public MessageList getMessagesFor(Object object) {
        return this.getMessagesFor(object, null);
    }

    public MessageList getMessagesFor(Object object, String property) {
        return this.getMessagesFor(object, property, -1);
    }

    public MessageList getMessagesFor(Object object, String property, int index) {
        MessageList result = new MessageList();
        block0: for (Message message : this.getMessages()) {
            List<ObjectProperty> op = message.getInvalidObjectProperties();
            for (ObjectProperty objectProperty : op) {
                if (!objectProperty.getObject().equals(object)) continue;
                if (property == null) {
                    result.add(message);
                    continue block0;
                }
                if (!property.equals(objectProperty.getProperty()) || index >= 0 && objectProperty.getIndex() != index) continue;
                result.add(message);
                continue block0;
            }
        }
        return result;
    }

    public void wrapUpMessages(String messageCode) {
        LinkedHashMap<String, Message> messageTextMap = new LinkedHashMap<String, Message>();
        for (Message message : this.getMessages()) {
            if (!message.getCode().equals(messageCode)) continue;
            Message msgByText = this.getMessageByText(messageTextMap, message);
            List<ObjectProperty> newInvalidObjects = this.concatInvalidObject(msgByText.getInvalidObjectProperties(), message.getInvalidObjectProperties());
            Message newMessage = new Message(msgByText.getCode(), msgByText.getText(), msgByText.getSeverity(), newInvalidObjects);
            messageTextMap.put(newMessage.getText(), newMessage);
        }
        this.setMessages(new ArrayList<Message>(messageTextMap.values()));
    }

    private Message getMessageByText(Map<String, Message> messageTextMap, Message message) {
        Message msgByText = messageTextMap.get(message.getText());
        if (msgByText == null) {
            msgByText = message;
        }
        return msgByText;
    }

    private List<ObjectProperty> concatInvalidObject(List<ObjectProperty> invalidObjectProperties, List<ObjectProperty> newObjectProperties) {
        if (invalidObjectProperties.equals(newObjectProperties)) {
            return invalidObjectProperties;
        }
        ArrayList<ObjectProperty> newOne = new ArrayList<ObjectProperty>();
        newOne.addAll(invalidObjectProperties);
        newOne.addAll(newObjectProperties);
        return newOne;
    }

    public MessageList map(UnaryOperator<Message> transformer) {
        return this.stream().map(transformer::apply).collect(MessageLists.collectMessages());
    }

    public MessageList map(Predicate<Message> shouldBeTransformed, UnaryOperator<Message> transformer) {
        return this.stream().map((? super T m) -> shouldBeTransformed.test((Message)m) ? (Message)transformer.apply((Message)m) : m).collect(MessageLists.collectMessages());
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    public void clear() {
        this.messages.clear();
    }

    public String toString() {
        return IpsStringUtils.join(this.messages, System.lineSeparator());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        block7: {
            MessageList other;
            block6: {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                try {
                    other = (MessageList)obj;
                    if (this.getMessages() != null) break block6;
                    if (other.getMessages() != null) {
                        return false;
                    }
                    break block7;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
            if (this.getMessages().equals(other.getMessages())) break block7;
            return false;
        }
        return true;
    }

    @Override
    public Spliterator<Message> spliterator() {
        return this.messages.spliterator();
    }

    public Stream<Message> stream() {
        return this.messages.stream();
    }

    public Stream<Message> parallelStream() {
        return this.messages.parallelStream();
    }
}

