/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.formula.IFormulaEvaluator;
import org.faktorips.runtime.formula.IFormulaEvaluatorFactory;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ProductComponentXmlUtil;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class FormulaHandler {
    private Object callerObject;
    private final IRuntimeRepository repository;
    private IFormulaEvaluator formulaEvaluator;
    private Map<String, String> availableFormulars = new LinkedHashMap<String, String>();

    public FormulaHandler(Object callerObject, IRuntimeRepository repository) {
        this.callerObject = callerObject;
        this.repository = repository;
    }

    public IRuntimeRepository getRepository() {
        return this.repository;
    }

    public IFormulaEvaluator getFormulaEvaluator() {
        return this.formulaEvaluator;
    }

    public void doInitFormulaFromXml(Element element) {
        IFormulaEvaluatorFactory factory;
        this.availableFormulars.putAll(ProductComponentXmlUtil.getAvailableFormulars(element));
        if (this.getFormulaEvaluator() != null) {
            return;
        }
        if (this.getRepository() != null && (factory = this.getRepository().getFormulaEvaluatorFactory()) != null) {
            Map<String, String> expressions = this.getCompiledExpressionsFromFormulas(element);
            this.formulaEvaluator = factory.createFormulaEvaluator(this.callerObject, expressions);
        }
    }

    protected Map<String, String> getCompiledExpressionsFromFormulas(Element element) {
        LinkedHashMap<String, String> expressions = new LinkedHashMap<String, String>();
        NodeList formulas = element.getElementsByTagName("Formula");
        int i = 0;
        while (i < formulas.getLength()) {
            Element aFormula = (Element)formulas.item(i);
            String name = aFormula.getAttribute("formulaSignature");
            NodeList nodeList = aFormula.getElementsByTagName("compiledExpression");
            if (nodeList.getLength() != 1) {
                throw new RuntimeException("Expression for Formula: " + name + " not found");
            }
            Element expression = (Element)nodeList.item(0);
            String formulaExpression = expression.getTextContent();
            expressions.put(name, formulaExpression);
            ++i;
        }
        return expressions;
    }

    public boolean isFormulaAvailable(String formularSignature) {
        String expression = this.availableFormulars.get(formularSignature);
        return !IpsStringUtils.isBlank(expression);
    }

    public void writeFormulaToXml(Element element) {
        this.addFormulasToElement(element, this.formulaEvaluator, this.availableFormulars);
    }

    protected void addFormulasToElement(Element element, IFormulaEvaluator formulaEvaluator, Map<String, String> availableFormulars) {
        if (availableFormulars != null) {
            for (Map.Entry<String, String> expressionEntry : availableFormulars.entrySet()) {
                Element formula = element.getOwnerDocument().createElement("Formula");
                formula.setAttribute("formulaSignature", expressionEntry.getKey());
                ValueToXmlHelper.addValueToElement(expressionEntry.getValue(), formula, "Expression");
                if (formulaEvaluator != null) {
                    String compiledExpression = formulaEvaluator.getNameToExpressionMap().get(expressionEntry.getKey());
                    ValueToXmlHelper.addCDataValueToElement(compiledExpression, formula, "compiledExpression");
                }
                element.appendChild(formula);
            }
        }
    }
}

