/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.faktorips.runtime.IProductObject;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.internal.ValidationRuleConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ValidationRules {
    private static final String XML_ELEMENT_VALIDATION_RULE_CONFIG = "ValidationRuleConfig";
    private final Map<String, ValidationRuleConfiguration> validationRulesConfigsByName = new LinkedHashMap<String, ValidationRuleConfiguration>();
    private final IProductObject productObject;

    public ValidationRules(IProductObject productObject) {
        this.productObject = productObject;
    }

    private IRuntimeRepository getRepository() {
        return this.productObject.getRepository();
    }

    void doInitValidationRuleConfigsFromXml(Element element) {
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && XML_ELEMENT_VALIDATION_RULE_CONFIG.equals(node.getNodeName())) {
                Element childElement = (Element)nl.item(i);
                ValidationRuleConfiguration config = new ValidationRuleConfiguration(childElement);
                this.validationRulesConfigsByName.put(config.getRuleName(), config);
            }
            ++i;
        }
    }

    void writeValidationRuleConfigsToXml(Element element) {
        for (Map.Entry<String, ValidationRuleConfiguration> vRuleEntry : this.validationRulesConfigsByName.entrySet()) {
            Element vRuleElement = element.getOwnerDocument().createElement(XML_ELEMENT_VALIDATION_RULE_CONFIG);
            vRuleElement.setAttribute("ruleName", vRuleEntry.getKey());
            ValidationRuleConfiguration vRule = vRuleEntry.getValue();
            vRuleElement.setAttribute("active", Boolean.toString(vRule.isActive()));
            element.appendChild(vRuleElement);
        }
    }

    void setValidationRuleActivated(String ruleName, boolean active) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.validationRulesConfigsByName.put(ruleName, new ValidationRuleConfiguration(ruleName, active));
    }

    boolean isValidationRuleActivated(String ruleName) {
        ValidationRuleConfiguration ruleConfig = this.validationRulesConfigsByName.get(ruleName);
        return ruleConfig != null && ruleConfig.isActive();
    }
}

