/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.validation.Relevance;
import org.faktorips.valueset.ValueSet;

public class ModelObjectAttribute {
    private final IModelObject modelObject;
    private final PolicyAttribute policyAttribute;

    private ModelObjectAttribute(IModelObject modelObject, PolicyAttribute policyAttribute) {
        this.modelObject = modelObject;
        this.policyAttribute = policyAttribute;
    }

    public static final ModelObjectAttribute of(@NonNull IModelObject modelObject, @NonNull PolicyAttribute policyAttribute) {
        Class<?> policyCmptTypeClassForAttribute = Objects.requireNonNull(policyAttribute, "policyAttribute must not be null").getType().getDeclarationClass();
        if (!policyCmptTypeClassForAttribute.isInstance(Objects.requireNonNull(modelObject, "modelObject must not be null"))) {
            throw new IllegalArgumentException("The model object " + modelObject + " is a " + IpsModel.getPolicyCmptType(modelObject) + " but the attribute " + policyAttribute.getName() + " belongs to " + policyCmptTypeClassForAttribute);
        }
        return new ModelObjectAttribute(modelObject, policyAttribute);
    }

    public static final ModelObjectAttribute of(@NonNull IModelObject modelObject, @NonNull String attributeName) {
        return ModelObjectAttribute.of(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(attributeName));
    }

    public IModelObject getModelObject() {
        return this.modelObject;
    }

    public PolicyAttribute getPolicyAttribute() {
        return this.policyAttribute;
    }

    public Object getValue() {
        return this.policyAttribute.getValue(this.modelObject);
    }

    public boolean isValuePresent() {
        return this.policyAttribute.isValuePresent(this.modelObject);
    }

    public boolean isEmpty() {
        return this.policyAttribute.isEmpty(this.modelObject);
    }

    public ModelObjectAttribute removeValue() {
        this.policyAttribute.removeValue(this.modelObject);
        return this;
    }

    public ValueSet<?> getValueSet() {
        return this.policyAttribute.getValueSet(this.modelObject);
    }

    public ModelObjectAttribute setValueSet(ValueSet<?> valueSet) {
        this.policyAttribute.setValueSet((IConfigurableModelObject)this.modelObject, valueSet);
        return this;
    }

    public Object getDefaultValue() {
        return this.policyAttribute.getDefaultValue((IConfigurableModelObject)this.modelObject);
    }

    public ModelObjectAttribute setDefaultValue(Object defaultValue) {
        this.policyAttribute.setDefaultValue((IConfigurableModelObject)this.modelObject, defaultValue);
        return this;
    }

    public boolean isIrrelevant() {
        return Relevance.isIrrelevant(this.modelObject, this.policyAttribute);
    }

    public boolean isRelevant() {
        return Relevance.isRelevant(this.modelObject, this.policyAttribute);
    }

    public boolean isMandatory() {
        return Relevance.isMandatory(this.modelObject, this.policyAttribute);
    }

    public boolean isOptional() {
        return Relevance.isOptional(this.modelObject, this.policyAttribute);
    }

    public ObjectProperty toObjectProperty() {
        return new ObjectProperty(this.modelObject, this.policyAttribute.getName());
    }
}

