/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.model.annotation.IpsAssociationAdder;
import org.faktorips.runtime.model.annotation.IpsAssociationRemover;
import org.faktorips.runtime.model.type.Association;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductAssociation;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;

public class PolicyAssociation
extends Association {
    private final Method addMethod;
    private final Method removeMethod;

    public PolicyAssociation(Type type, Method getterMethod, Method addMethod, Method removeMethod) {
        super(type, getterMethod);
        this.addMethod = addMethod;
        this.removeMethod = removeMethod;
    }

    @Override
    public PolicyCmptType getType() {
        return (PolicyCmptType)super.getType();
    }

    @Override
    @Deprecated
    public PolicyCmptType getModelType() {
        return this.getType();
    }

    @Override
    public PolicyAssociation createOverwritingAssociationFor(Type subType) {
        return new PolicyAssociation(subType, this.getGetterMethod(), this.addMethod, this.removeMethod);
    }

    @Override
    public ProductCmptType getMatchingAssociationSourceType() {
        return (ProductCmptType)super.getMatchingAssociationSourceType();
    }

    @Override
    public ProductAssociation getMatchingAssociation() {
        return (ProductAssociation)super.getMatchingAssociation();
    }

    public Optional<ProductAssociation> findMatchingAssociation() {
        return Optional.ofNullable(this.getMatchingAssociation());
    }

    @Override
    public PolicyCmptType getTarget() {
        return (PolicyCmptType)super.getTarget();
    }

    public List<IModelObject> getTargetObjects(IModelObject source) {
        ArrayList<IModelObject> targets = new ArrayList<IModelObject>();
        Object object = this.invokeMethod(this.getGetterMethod(), source, new Object[0]);
        if (object instanceof Iterable) {
            for (Object target : (Iterable)object) {
                targets.add((IModelObject)target);
            }
        } else if (object instanceof IModelObject) {
            targets.add((IModelObject)object);
        }
        return targets;
    }

    public <S extends IModelObject> S addTargetObjects(S source, Collection<IModelObject> targets) {
        if (this.isToOneAssociation() && targets.size() > 1) {
            throw new IllegalArgumentException(String.format("The association %s on source object %s allows a maxmimum of one target object but %s were provided.", this.getName(), source, targets.size()));
        }
        if (this.addMethod == null) {
            if (this.isOverriding()) {
                return this.getSuperAssociation().addTargetObjects(source, targets);
            }
            throw new IllegalArgumentException(String.format("The association %s on source object %s does not allow %s target objects%s.", this.getName(), source, this.isToOneAssociation() ? "setting" : "adding", this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationAdder.class.getSimpleName() + " exists"));
        }
        for (IModelObject target : targets) {
            this.invokeMethod(this.addMethod, source, target);
        }
        return source;
    }

    public <S extends IModelObject> S addTargetObjects(S source, IModelObject ... targets) {
        return this.addTargetObjects(source, Arrays.asList(targets));
    }

    public <S extends IModelObject> S removeTargetObjects(S source, List<IModelObject> targetsToRemove) {
        if (this.isToOneAssociation()) {
            if (targetsToRemove.size() > 1) {
                throw new IllegalArgumentException(String.format("The association %s on source object %s allows a maxmimum of one target object but %s were tried to remove.", this.getName(), source, targetsToRemove.size()));
            }
            if (targetsToRemove.size() == 1) {
                this.resetTargetObject(source, targetsToRemove.get(0));
            }
        } else {
            if (this.removeMethod == null) {
                if (this.isOverriding()) {
                    return this.getSuperAssociation().removeTargetObjects(source, targetsToRemove);
                }
                throw new IllegalArgumentException(String.format("The association %s on source object %s does not allow removing target objects%s.", this.getName(), source, this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationRemover.class.getSimpleName() + " exists"));
            }
            for (IModelObject targetToRemove : targetsToRemove) {
                this.invokeMethod(this.removeMethod, source, targetToRemove);
            }
        }
        return source;
    }

    @Override
    public PolicyAssociation getSuperAssociation() {
        return (PolicyAssociation)super.getSuperAssociation();
    }

    public <S extends IModelObject> S removeTargetObjects(S source, IModelObject ... targetsToRemove) {
        return this.removeTargetObjects(source, Arrays.asList(targetsToRemove));
    }

    private <S extends IModelObject> void resetTargetObject(S source, IModelObject targetToReset) {
        if (this.getTargetObjects(source).contains(targetToReset)) {
            this.addTargetObjects(source, new IModelObject[1]);
        }
    }
}

