/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.faktorips.annotation.UtilityClass;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IModelObjectVisitor;
import org.faktorips.runtime.IVisitorSupport;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.ModelObjectAttribute;

@UtilityClass
public class ModelObjectAttributes {
    private static final Predicate<ModelObjectAttribute> IS_IRRELEVANT = ModelObjectAttribute::isIrrelevant;
    private static final Predicate<ModelObjectAttribute> IS_NOT_EMPTY = ModelObjectAttribute::isValuePresent;
    public static final Predicate<ModelObjectAttribute> IS_IRRELEVANT_BUT_NOT_EMPTY = IS_NOT_EMPTY.and(IS_IRRELEVANT);

    private ModelObjectAttributes() {
    }

    public static List<ModelObjectAttribute> of(IModelObject modelObject) {
        return IpsModel.getPolicyCmptType(modelObject).getModelObjectAttributes(modelObject);
    }

    public static List<ModelObjectAttribute> ofIncludingChildren(IModelObject modelObject) {
        ArrayList<ModelObjectAttribute> modelObjectAttributes = new ArrayList<ModelObjectAttribute>();
        IModelObjectVisitor propertyCollectorVisitor = mo -> {
            modelObjectAttributes.addAll(ModelObjectAttributes.of(mo));
            return true;
        };
        IVisitorSupport.orGenericVisitorSupport(modelObject).accept(propertyCollectorVisitor);
        return modelObjectAttributes;
    }

    public static List<ModelObjectAttribute> resetIrrelevantAttributes(IModelObject modelObject) {
        return ModelObjectAttributes.resetAttributes(modelObject, IS_IRRELEVANT_BUT_NOT_EMPTY);
    }

    public static List<ModelObjectAttribute> resetAttributes(IModelObject modelObject, Predicate<ModelObjectAttribute> shouldReset) {
        return ModelObjectAttributes.ofIncludingChildren(modelObject).stream().filter(shouldReset::test).map(ModelObjectAttribute::removeValue).collect(Collectors.toList());
    }
}

