/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.validation;

import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.validation.IGenericAttributeValidationConfiguration;
import org.faktorips.values.ObjectUtil;
import org.faktorips.valueset.Range;
import org.faktorips.valueset.ValueSet;

public class DefaultGenericAttributeValidationConfiguration
implements IGenericAttributeValidationConfiguration {
    public static final String ERROR_MANDATORY_MSG_CODE_PREFIX = "InvalidAttribute.Mandatory";
    public static final String ERROR_IRRELEVANT_MSG_CODE_PREFIX = "InvalidAttribute.Irrelevant";
    public static final String ERROR_INVALID_MSG_CODE_PREFIX = "InvalidAttribute.Invalid";
    private static final String MSG_KEY_VALUE_IN_RANGE = "ValueInRange";
    private static final String MSG_KEY_VALUE_IN_RANGE_LOWER = "ValueInRangeLower";
    private static final String MSG_KEY_VALUE_IN_RANGE_UPPER = "ValueInRangeUpper";
    private static final String MSG_KEY_VALUE_IN_RANGE_STEPS = "ValueInRangeSteps";
    private static final String RESOURCE_BUNDLE_NAME = DefaultGenericAttributeValidationConfiguration.class.getName();
    private final Locale locale;
    private final ResourceBundle messages;

    public DefaultGenericAttributeValidationConfiguration(Locale locale) {
        this(ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale), locale);
    }

    public DefaultGenericAttributeValidationConfiguration(ResourceBundle messages, Locale locale) {
        this.messages = Objects.requireNonNull(messages, "messages must not be null");
        this.locale = Objects.requireNonNull(locale, "locale must not be null");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundle getMessages() {
        return this.messages;
    }

    @Override
    public boolean shouldValidate(PolicyAttribute policyAttribute, IModelObject modelObject) {
        return true;
    }

    protected Message createErrorMessage(PolicyAttribute policyAttribute, IModelObject modelObject, String msgCodePrefix, String message) {
        String msgCode = this.createMsgCode(msgCodePrefix, modelObject, policyAttribute);
        return Message.error(message).code(msgCode).invalidObjectWithProperties(modelObject, policyAttribute.getName()).create();
    }

    protected String createMsgCode(String msgCodePrefix, IModelObject modelObject, PolicyAttribute policyAttribute) {
        return String.format("%s.%s.%s", msgCodePrefix, IpsModel.getPolicyCmptType(modelObject).getName(), policyAttribute.getName());
    }

    protected String format(String msgKey, Object ... replacementParameters) {
        return String.format(this.messages.getString(msgKey), replacementParameters);
    }

    protected String getLabelFor(PolicyAttribute policyAttribute, IModelObject modelObject) {
        return String.valueOf('\"') + policyAttribute.getLabel(this.locale) + '\"';
    }

    @Override
    public Message createMessageForMissingMandatoryValue(PolicyAttribute policyAttribute, IModelObject modelObject) {
        return this.createErrorMessage(policyAttribute, modelObject, ERROR_MANDATORY_MSG_CODE_PREFIX, this.format(ERROR_MANDATORY_MSG_CODE_PREFIX, this.getLabelFor(policyAttribute, modelObject)));
    }

    @Override
    public Message createMessageForValuePresentForIrrelevantAttribute(PolicyAttribute policyAttribute, IModelObject modelObject) {
        return this.createErrorMessage(policyAttribute, modelObject, ERROR_IRRELEVANT_MSG_CODE_PREFIX, this.format(ERROR_IRRELEVANT_MSG_CODE_PREFIX, this.getLabelFor(policyAttribute, modelObject)));
    }

    @Override
    public Message createMessageForValueNotInAllowedValueSet(PolicyAttribute policyAttribute, IModelObject modelObject) {
        StringBuilder sb = new StringBuilder(this.format(ERROR_INVALID_MSG_CODE_PREFIX, this.getLabelFor(policyAttribute, modelObject)));
        ValueSet<?> valueSet = policyAttribute.getValueSet(modelObject);
        if (valueSet.isRange()) {
            String stepLabel;
            sb.append(' ');
            Range range = (Range)valueSet;
            Comparable lowerBound = range.getLowerBound();
            Comparable upperBound = range.getUpperBound();
            Comparable step = range.getStep();
            String string = stepLabel = ObjectUtil.isNull((Object)step) ? "" : this.format(MSG_KEY_VALUE_IN_RANGE_STEPS, step);
            if (ObjectUtil.isNull((Object)lowerBound)) {
                sb.append(this.format(MSG_KEY_VALUE_IN_RANGE_UPPER, upperBound, stepLabel));
            } else if (ObjectUtil.isNull((Object)upperBound)) {
                sb.append(this.format(MSG_KEY_VALUE_IN_RANGE_LOWER, lowerBound, stepLabel));
            } else {
                sb.append(this.format(MSG_KEY_VALUE_IN_RANGE, lowerBound, upperBound, stepLabel));
            }
        }
        return this.createErrorMessage(policyAttribute, modelObject, ERROR_INVALID_MSG_CODE_PREFIX, sb.toString());
    }
}

