/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.validation;

import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.valueset.ValueSet;

public enum Relevance {
    IRRELEVANT,
    OPTIONAL,
    MANDATORY;


    public static boolean isIrrelevant(IModelObject modelObject, String property) {
        return Relevance.isIrrelevant(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static boolean isIrrelevant(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return IRRELEVANT == Relevance.of(modelObject, policyAttribute);
    }

    public static boolean isMandatory(IModelObject modelObject, String property) {
        return Relevance.isMandatory(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static boolean isMandatory(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return MANDATORY == Relevance.of(modelObject, policyAttribute);
    }

    public static boolean isOptional(IModelObject modelObject, String property) {
        return Relevance.isOptional(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static boolean isOptional(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return OPTIONAL == Relevance.of(modelObject, policyAttribute);
    }

    public static boolean isRelevant(IModelObject modelObject, String property) {
        return Relevance.isRelevant(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static boolean isRelevant(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return !Relevance.isIrrelevant(modelObject, policyAttribute);
    }

    public static Relevance of(IModelObject modelObject, String property) {
        return Relevance.of(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static Relevance of(IModelObject modelObject, PolicyAttribute policyAttribute) {
        ValueSet<?> valueSet = policyAttribute.getValueSet(modelObject);
        if (valueSet == null || valueSet.isEmpty()) {
            return IRRELEVANT;
        }
        if (valueSet.containsNull()) {
            return OPTIONAL;
        }
        return MANDATORY;
    }
}

