/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.faktorips.runtime.DefaultCacheFactory;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.internal.AbstractClassLoadingRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.ReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClassloaderRuntimeRepository
extends AbstractClassLoadingRuntimeRepository {
    public static final String REPOSITORY_XML_ELEMENT = "ProductComponentRegistry";
    public static final String TABLE_OF_CONTENTS_FILE = "faktorips-repository-toc.xml";
    private static ThreadLocal<DocumentBuilder> docBuilderHolder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            return ClassloaderRuntimeRepository.createDocumentBuilder();
        }
    };
    private static final InputStream EMPTY_INPUT_STREAM = new EmptyInputStream();
    private final String tocResourcePath;

    public ClassloaderRuntimeRepository(ClassLoader cl, String basePackage) {
        this(cl, basePackage, TABLE_OF_CONTENTS_FILE, new DefaultCacheFactory(cl));
    }

    public ClassloaderRuntimeRepository(ClassLoader cl, String basePackage, String pathToToc) {
        this(cl, basePackage, pathToToc, new DefaultCacheFactory(cl));
    }

    public ClassloaderRuntimeRepository(ClassLoader cl, String basePackage, String pathToToc, ICacheFactory cacheFactory) {
        super(basePackage, cacheFactory, cl);
        if (cl == null) {
            throw new NullPointerException();
        }
        if (basePackage == null) {
            throw new NullPointerException();
        }
        if (pathToToc == null) {
            throw new NullPointerException();
        }
        this.tocResourcePath = "".equals(basePackage) ? pathToToc : String.valueOf(basePackage.replace('.', '/')) + '/' + pathToToc;
        this.initialize();
    }

    private ClassloaderRuntimeRepository(String tocResource, ClassLoader cl, ICacheFactory cacheFactory) {
        super(tocResource, cacheFactory, cl);
        if (tocResource == null) {
            throw new NullPointerException();
        }
        if (cl == null) {
            throw new NullPointerException();
        }
        this.tocResourcePath = tocResource;
        this.initialize();
    }

    public static final ClassloaderRuntimeRepository create(String tocResource) {
        return ClassloaderRuntimeRepository.create(tocResource, ClassloaderRuntimeRepository.class.getClassLoader(), new DefaultCacheFactory(ClassloaderRuntimeRepository.class.getClassLoader()));
    }

    public static final ClassloaderRuntimeRepository create(String tocResource, ICacheFactory cacheFactory) {
        return ClassloaderRuntimeRepository.create(tocResource, ClassloaderRuntimeRepository.class.getClassLoader(), cacheFactory);
    }

    public static final ClassloaderRuntimeRepository create(String tocResource, ClassLoader cl) {
        return ClassloaderRuntimeRepository.create(tocResource, cl, new DefaultCacheFactory(cl));
    }

    public static final ClassloaderRuntimeRepository create(String tocResource, ClassLoader cl, ICacheFactory cacheFactory) {
        return new ClassloaderRuntimeRepository(tocResource, cl, cacheFactory);
    }

    protected DocumentBuilder getDocumentBuilder() {
        return docBuilderHolder.get();
    }

    @Override
    protected ReadonlyTableOfContents loadTableOfContents() {
        Document doc;
        InputStream is = null;
        try {
            try {
                is = this.getClassLoader().getResourceAsStream(this.tocResourcePath);
                if (is == null) {
                    throw new IllegalArgumentException("Can't find table of contents file " + this.tocResourcePath);
                }
                doc = this.getDocumentBuilder().parse(is);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading table of contents from " + this.tocResourcePath, e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            Element tocElement = doc.getDocumentElement();
            ReadonlyTableOfContents toc = new ReadonlyTableOfContents(this.getClassLoader());
            toc.initFromXml(tocElement);
            return toc;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating toc from xml.", e);
        }
    }

    @Override
    protected String getProductComponentGenerationImplClass(GenerationTocEntry tocEntry) {
        return tocEntry.getImplementationClassName();
    }

    @Override
    protected Element getDocumentElement(ProductCmptTocEntry tocEntry) {
        return this.getDocumentElementInternal(tocEntry);
    }

    @Override
    protected Element getDocumentElement(GenerationTocEntry tocEntry) {
        Element docElement = this.getDocumentElement(tocEntry.getParent());
        NodeList nl = docElement.getChildNodes();
        DateTime validFrom = tocEntry.getValidFrom();
        int i = 0;
        while (i < nl.getLength()) {
            Element genElement;
            DateTime generationValidFrom;
            if ("Generation".equals(nl.item(i).getNodeName()) && validFrom.equals(generationValidFrom = DateTime.parseIso((genElement = (Element)nl.item(i)).getAttribute("validFrom")))) {
                return genElement;
            }
            ++i;
        }
        throw new RuntimeException("Can't find the generation for the toc entry " + tocEntry);
    }

    @Override
    protected Element getDocumentElement(TestCaseTocEntry tocEntry) {
        return this.getDocumentElementInternal(tocEntry);
    }

    @Override
    protected InputStream getXmlAsStream(EnumContentTocEntry tocEntry) {
        String xmlResourceName = tocEntry.getXmlResourceName();
        if (IpsStringUtils.isBlank(xmlResourceName)) {
            return EMPTY_INPUT_STREAM;
        }
        InputStream is = this.getClassLoader().getResourceAsStream(xmlResourceName);
        if (is == null) {
            throw new RuntimeException("Cant't load the input stream for the enumeration content resource " + xmlResourceName);
        }
        return is;
    }

    private Element getDocumentElementInternal(TocEntry tocEntry) {
        Document doc;
        String resource = tocEntry.getXmlResourceName();
        InputStream is = this.getClassLoader().getResourceAsStream(resource);
        if (is == null) {
            throw new RuntimeException("Can't find resource " + resource + " for toc entry " + tocEntry);
        }
        try {
            try {
                doc = this.getDocumentBuilder().parse(is);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't parse xml resource " + resource, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close the input stream of the resource: " + resource, e);
            }
        }
        Element element = doc.getDocumentElement();
        if (element == null) {
            throw new RuntimeException("Xml resource " + resource + " hasn't got a document element.");
        }
        return element;
    }

    private static final DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new RuntimeException("Error creating document builder.", e1);
        }
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        return builder;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    protected InputStream getXmlAsStream(TableContentTocEntry tocEntry) {
        InputStream is = this.getClassLoader().getResourceAsStream(tocEntry.getXmlResourceName());
        if (is == null) {
            throw new RuntimeException("Can't find resource " + tocEntry.getXmlResourceName() + " for toc entry " + tocEntry);
        }
        return is;
    }

    @Override
    protected <T> Element getDocumentElement(CustomTocEntryObject<T> tocEntry) {
        return this.getDocumentElementInternal(tocEntry);
    }

    private static final class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

