/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductObject;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsExtensionProperty;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.util.MessagesHelper;

public abstract class ModelElement {
    private final String name;
    private final Map<String, Object> extPropertyValues;

    public ModelElement(String name, IpsExtensionProperties extensionProperties) {
        this.name = name;
        this.extPropertyValues = this.initExtensionPropertyMap(extensionProperties);
    }

    private Map<String, Object> initExtensionPropertyMap(IpsExtensionProperties extensionPropertiesAnnotation) {
        Map<String, Object> result = Collections.emptyMap();
        if (extensionPropertiesAnnotation != null) {
            IpsExtensionProperty[] extensionProperties = extensionPropertiesAnnotation.value();
            result = new LinkedHashMap<String, Object>(extensionProperties.length, 1.0f);
            IpsExtensionProperty[] ipsExtensionPropertyArray = extensionProperties;
            int n = extensionProperties.length;
            int n2 = 0;
            while (n2 < n) {
                IpsExtensionProperty ipsExtensionProperty = ipsExtensionPropertyArray[n2];
                result.put(ipsExtensionProperty.id(), this.initValue(ipsExtensionProperty));
                ++n2;
            }
        }
        return result;
    }

    private Object initValue(IpsExtensionProperty ipsExtensionProperty) {
        if (ipsExtensionProperty.isNull()) {
            return null;
        }
        return ipsExtensionProperty.value();
    }

    public String getName() {
        return this.name;
    }

    public String getLabel(Locale locale) {
        return this.getDocumentation(locale, DocumentationKind.LABEL, this.getName());
    }

    public String getDescription(Locale locale) {
        return this.getDocumentation(locale, DocumentationKind.DESCRIPTION, "");
    }

    protected abstract String getMessageKey(DocumentationKind var1);

    protected String getDocumentation(Locale locale, DocumentationKind type, String fallback) {
        MessagesHelper messageHelper = this.getMessageHelper();
        if (messageHelper != null) {
            return messageHelper.getMessageOr(this.getMessageKey(type), locale, fallback);
        }
        return fallback;
    }

    protected abstract MessagesHelper getMessageHelper();

    protected MessagesHelper createMessageHelper(IpsDocumented documentedAnnotation, ClassLoader classLoader) {
        if (documentedAnnotation != null) {
            String documentationResourceBundle = documentedAnnotation.bundleName();
            Locale defaultLocale = new Locale(documentedAnnotation.defaultLocale());
            return new MessagesHelper(documentationResourceBundle, classLoader, defaultLocale);
        }
        return null;
    }

    public Object getExtensionPropertyValue(String propertyId) {
        if (this.extPropertyValues == null) {
            return null;
        }
        return this.extPropertyValues.get(propertyId);
    }

    public Set<String> getExtensionPropertyIds() {
        if (this.extPropertyValues == null) {
            return new HashSet<String>(0);
        }
        return this.extPropertyValues.keySet();
    }

    protected Object invokeMethod(Method method, Object source, Object ... arguments) {
        try {
            return method.invoke(source, arguments);
        }
        catch (NullPointerException e) {
            throw this.createGetterError(source, method, arguments, e);
        }
        catch (IllegalArgumentException e) {
            throw this.createGetterError(source, method, arguments, e);
        }
        catch (IllegalAccessException e) {
            throw this.createGetterError(source, method, arguments, e);
        }
        catch (InvocationTargetException e) {
            throw this.createGetterError(source, method, arguments, e.getCause());
        }
        catch (SecurityException e) {
            throw this.createGetterError(source, method, arguments, e);
        }
    }

    private IllegalArgumentException createGetterError(Object source, Method method, Object[] args, Throwable e) {
        return new IllegalArgumentException(String.format("Could not call %s(%s) on source object %s.", method.getName(), IpsStringUtils.join(args), source), e);
    }

    protected Object invokeField(Field field, Object source) {
        try {
            return field.get(source);
        }
        catch (NullPointerException e) {
            throw this.createFieldError(source, field, e);
        }
        catch (IllegalArgumentException e) {
            throw this.createFieldError(source, field, e);
        }
        catch (IllegalAccessException e) {
            throw this.createFieldError(source, field, e);
        }
        catch (SecurityException e) {
            throw this.createFieldError(source, field, e);
        }
    }

    private IllegalArgumentException createFieldError(Object source, Field field, Exception e) {
        return new IllegalArgumentException(String.format("Could not get value of %s on source object %s.", field.getName(), source), e);
    }

    protected static Object getRelevantProductObject(IProductComponent productComponent, Calendar effectiveDate, boolean changingOverTime) {
        IProductObject source = productComponent;
        if (changingOverTime) {
            source = effectiveDate == null ? productComponent.getLatestProductComponentGeneration() : productComponent.getGenerationBase(effectiveDate);
        }
        return source;
    }

    public String toString() {
        return this.getName();
    }
}

