/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepositoryManager;

public abstract class AbstractRuntimeRepositoryManager
implements IRuntimeRepositoryManager {
    private volatile IRuntimeRepository currentRuntimeRepository;
    private List<IRuntimeRepositoryManager> managers = new CopyOnWriteArrayList<IRuntimeRepositoryManager>();
    private volatile List<IRuntimeRepositoryManager> allManagers;

    @Override
    @Deprecated
    public synchronized IRuntimeRepository getActualRuntimeRepository() {
        return this.getCurrentRuntimeRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRuntimeRepository getCurrentRuntimeRepository() {
        IRuntimeRepository runtimeRepository = this.currentRuntimeRepository;
        if (this.isRepositoryUpToDate(runtimeRepository) && this.areReferencedRepositoriesUpToDate()) {
            return runtimeRepository;
        }
        AbstractRuntimeRepositoryManager abstractRuntimeRepositoryManager = this;
        synchronized (abstractRuntimeRepositoryManager) {
            runtimeRepository = this.currentRuntimeRepository;
            if (!this.isRepositoryUpToDate(runtimeRepository) || !this.areReferencedRepositoriesUpToDate()) {
                runtimeRepository = this.createNewRuntimeRepository();
                for (IRuntimeRepositoryManager manager : this.managers) {
                    IRuntimeRepository referencedRuntimeRepository = manager.getCurrentRuntimeRepository();
                    if (referencedRuntimeRepository == null) continue;
                    runtimeRepository.addDirectlyReferencedRepository(referencedRuntimeRepository);
                }
                this.currentRuntimeRepository = runtimeRepository;
            }
            return this.currentRuntimeRepository;
        }
    }

    protected abstract boolean isRepositoryUpToDate(IRuntimeRepository var1);

    protected abstract IRuntimeRepository createNewRuntimeRepository();

    private boolean areReferencedRepositoriesUpToDate() {
        ArrayList<IRuntimeRepository> directReferencedRepos = new ArrayList<IRuntimeRepository>(this.currentRuntimeRepository.getDirectlyReferencedRepositories());
        for (IRuntimeRepositoryManager manager : this.managers) {
            IRuntimeRepository referencedRepository = manager.getCurrentRuntimeRepository();
            if (referencedRepository == null || directReferencedRepos.remove(referencedRepository)) continue;
            return false;
        }
        return directReferencedRepos.isEmpty();
    }

    @Override
    public final void addDirectlyReferencedManager(IRuntimeRepositoryManager manager) {
        this.allManagers = null;
        this.managers.add(manager);
    }

    @Override
    public List<IRuntimeRepositoryManager> getDirectlyReferencedRepositoryManagers() {
        return Collections.unmodifiableList(this.managers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IRuntimeRepositoryManager> getAllReferencedRepositoryManagers() {
        List<IRuntimeRepositoryManager> result = this.allManagers;
        if (result != null) {
            return result;
        }
        AbstractRuntimeRepositoryManager abstractRuntimeRepositoryManager = this;
        synchronized (abstractRuntimeRepositoryManager) {
            result = this.allManagers;
            if (result == null) {
                result = new ArrayList<IRuntimeRepositoryManager>(this.managers.size());
                LinkedList<IRuntimeRepositoryManager> candidates = new LinkedList<IRuntimeRepositoryManager>();
                candidates.add(this);
                while (!candidates.isEmpty()) {
                    IRuntimeRepositoryManager candidate = (IRuntimeRepositoryManager)candidates.get(0);
                    candidates.remove(0);
                    if (candidate != this && !result.contains(candidate)) {
                        result.add(candidate);
                    }
                    for (IRuntimeRepositoryManager newCandidate : candidate.getDirectlyReferencedRepositoryManagers()) {
                        candidates.add(newCandidate);
                    }
                }
                this.allManagers = result = Collections.unmodifiableList(result);
            }
            return this.allManagers;
        }
    }
}

