/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.faktorips.runtime.util.StringBuilderJoiner;

public final class IpsStringUtils {
    public static final String EMPTY = "";

    private IpsStringUtils() {
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static final boolean isNotEmpty(String s) {
        return !IpsStringUtils.isEmpty(s);
    }

    public static final boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static final String join(Collection<?> collection, String separator) {
        return IpsStringUtils.join(collection, separator);
    }

    public static final String join(Iterable<?> iterable, String separator) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, separator, t -> {
            StringBuilder stringBuilder2 = stringBuilder.append(Objects.toString(t));
        });
        return stringBuilder.toString();
    }

    public static final String join(Iterable<?> iterable) {
        return IpsStringUtils.join(iterable, ", ");
    }

    public static final String join(Object[] objectArray) {
        return IpsStringUtils.join(Arrays.asList(objectArray));
    }

    public static final String join(Object[] objectArray, String separator) {
        return IpsStringUtils.join(Arrays.asList(objectArray), separator);
    }

    public static final <T> String join(Iterable<T> iterable, Function<? super T, String> toString) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, (? super T t) -> {
            StringBuilder stringBuilder2 = stringBuilder.append((String)toString.apply(t));
        });
        return stringBuilder.toString();
    }

    public static final <T> String join(Iterable<T> iterable, Function<? super T, String> toString, String separator) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, separator, t -> {
            StringBuilder stringBuilder2 = stringBuilder.append((String)toString.apply(t));
        });
        return stringBuilder.toString();
    }

    public static final String toLowerFirstChar(String string) {
        if (IpsStringUtils.isEmpty(string)) {
            return string;
        }
        char firstChar = string.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return string;
        }
        return String.valueOf(Character.toLowerCase(firstChar)) + string.substring(1);
    }
}

