/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Optional;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.IpsAssociation;
import org.faktorips.runtime.model.annotation.IpsDerivedUnion;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsInverseAssociation;
import org.faktorips.runtime.model.annotation.IpsMatchingAssociation;
import org.faktorips.runtime.model.annotation.IpsSubsetOfDerivedUnion;
import org.faktorips.runtime.model.type.AssociationKind;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;

public abstract class Association
extends TypePart {
    private final IpsAssociation annotation;
    private final Method getter;

    public Association(Type type, Method getterMethod) {
        super(Association.getAssociationAnnotation(getterMethod).name(), type, getterMethod.getAnnotation(IpsExtensionProperties.class));
        this.annotation = Association.getAssociationAnnotation(getterMethod);
        this.getter = getterMethod;
    }

    private static IpsAssociation getAssociationAnnotation(Method getterMethod) {
        return getterMethod.getAnnotation(IpsAssociation.class);
    }

    public String getLabelForPlural(Locale locale) {
        return this.getDocumentation(locale, DocumentationKind.PLURAL_LABEL, this.getNamePlural());
    }

    public AssociationKind getAssociationKind() {
        return this.annotation.kind();
    }

    public int getMinCardinality() {
        return this.annotation.min();
    }

    public int getMaxCardinality() {
        return this.annotation.max();
    }

    public String getNamePlural() {
        return this.annotation.pluralName();
    }

    public Type getTarget() {
        return IpsModel.getType(this.annotation.targetClass());
    }

    public String getUsedName() {
        return this.isTargetRolePluralRequired() ? this.getNamePlural() : this.getName();
    }

    private boolean isTargetRolePluralRequired() {
        return Iterable.class.isAssignableFrom(this.getter.getReturnType());
    }

    public boolean isDerivedUnion() {
        return this.getter.isAnnotationPresent(IpsDerivedUnion.class);
    }

    public boolean isSubsetOfADerivedUnion() {
        return this.getter.isAnnotationPresent(IpsSubsetOfDerivedUnion.class);
    }

    public String getInverseAssociation() {
        if (this.getter.isAnnotationPresent(IpsInverseAssociation.class)) {
            return this.getter.getAnnotation(IpsInverseAssociation.class).value();
        }
        return null;
    }

    public boolean isMatchingAssociationPresent() {
        return this.getter.isAnnotationPresent(IpsMatchingAssociation.class);
    }

    public String getMatchingAssociationName() {
        if (this.getter.isAnnotationPresent(IpsMatchingAssociation.class)) {
            return this.getter.getAnnotation(IpsMatchingAssociation.class).name();
        }
        return null;
    }

    public Association getMatchingAssociation() {
        Type matchingAssociationSourceType = this.getMatchingAssociationSourceType();
        if (matchingAssociationSourceType == null) {
            return null;
        }
        return matchingAssociationSourceType.getAssociation(this.getMatchingAssociationName());
    }

    public Optional<? extends Association> findMatchingAssociation() {
        return Optional.ofNullable(this.getMatchingAssociation());
    }

    public String getMatchingAssociationSource() {
        Type matchingAssociationSource = this.getMatchingAssociationSourceType();
        if (matchingAssociationSource != null) {
            return matchingAssociationSource.getName();
        }
        return null;
    }

    public Type getMatchingAssociationSourceType() {
        if (this.getter.isAnnotationPresent(IpsMatchingAssociation.class)) {
            return IpsModel.getType(this.getter.getAnnotation(IpsMatchingAssociation.class).source());
        }
        return null;
    }

    public boolean isOverriding() {
        return this.getType().findSuperType().map(s -> s.isAssociationPresent(this.getName())).orElse(false);
    }

    public Association getSuperAssociation() {
        return this.findSuperAssociation().orElse(null);
    }

    public Optional<Association> findSuperAssociation() {
        return this.isOverriding() ? this.getType().findSuperType().map(s -> s.getAssociation(this.getName())) : Optional.empty();
    }

    protected Method getGetterMethod() {
        return this.getter;
    }

    public abstract Association createOverwritingAssociationFor(Type var1);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUsedName());
        sb.append(": ");
        sb.append(this.getTarget().getName());
        sb.append('(');
        sb.append((Object)this.getAssociationKind());
        sb.append(' ');
        if (this.isDerivedUnion()) {
            sb.append(", Derived Union ");
        }
        if (this.isSubsetOfADerivedUnion()) {
            sb.append(", Subset of a Derived Union ");
        }
        sb.append(this.getMinCardinality());
        sb.append("..");
        sb.append(this.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.valueOf(this.getMaxCardinality()));
        if (this.isMatchingAssociationPresent()) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }

    protected boolean isToOneAssociation() {
        return this.getMaxCardinality() == 1;
    }
}

