/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.faktorips.runtime.CardinalityRange;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.model.annotation.IpsAssociationAdder;
import org.faktorips.runtime.model.annotation.IpsAssociationLinks;
import org.faktorips.runtime.model.annotation.IpsAssociationRemover;
import org.faktorips.runtime.model.type.Association;
import org.faktorips.runtime.model.type.PolicyAssociation;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;

public class ProductAssociation
extends Association {
    private final boolean changingOverTime;
    private final Method getLinksMethod;
    private final Method addMethodWithCardinality;
    private final Method addMethod;
    private final Method removeMethod;

    public ProductAssociation(Type type, Method getterMethod, Method addMethod, Method addMethodWithCardinality, Method removeMethod, boolean changingOverTime, Method getLinksMethod) {
        super(type, getterMethod);
        this.addMethod = addMethod;
        this.addMethodWithCardinality = addMethodWithCardinality;
        this.removeMethod = removeMethod;
        this.changingOverTime = changingOverTime;
        this.getLinksMethod = getLinksMethod;
    }

    @Override
    public ProductAssociation createOverwritingAssociationFor(Type subType) {
        return new ProductAssociation(subType, this.getGetterMethod(), this.addMethod, this.addMethodWithCardinality, this.removeMethod, this.changingOverTime, this.getLinksMethod);
    }

    @Override
    public ProductCmptType getType() {
        return (ProductCmptType)super.getType();
    }

    @Override
    @Deprecated
    public ProductCmptType getModelType() {
        return this.getType();
    }

    @Override
    public ProductCmptType getTarget() {
        return (ProductCmptType)super.getTarget();
    }

    public List<IProductComponent> getTargetObjects(IProductComponent productComponentSource, Calendar effectiveDate) {
        ArrayList<IProductComponent> targets = new ArrayList<IProductComponent>();
        Object source = ProductAssociation.getRelevantProductObject(productComponentSource, effectiveDate, this.isChangingOverTime());
        Object returnValue = ProductAssociation.invokeMethod(this.getGetterMethod(), source, new Object[0]);
        if (returnValue instanceof Iterable) {
            for (Object target : (Iterable)returnValue) {
                targets.add((IProductComponent)target);
            }
        } else if (returnValue instanceof IProductComponent) {
            targets.add((IProductComponent)returnValue);
        }
        return targets;
    }

    public <S extends IProductComponent> S addTargetObjects(S source, Calendar effectiveDate, Collection<IProductComponent> targets) {
        if (this.isToOneAssociation() && targets.size() > 1) {
            throw new IllegalArgumentException(String.format("The association %s on source object %s allows a maxmimum of one target object but %s were provided.", this.getName(), source, targets.size()));
        }
        if (this.addMethod == null) {
            if (this.isOverriding()) {
                return this.getSuperAssociation().addTargetObjects(source, effectiveDate, targets);
            }
            throw new IllegalArgumentException(String.format("The association %s on source object %s does not allow %s target objects%s.", this.getName(), source, this.isToOneAssociation() ? "setting" : "adding", this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationAdder.class.getSimpleName() + " exists"));
        }
        Object relevantSource = ProductAssociation.getRelevantProductObject(source, effectiveDate, this.isChangingOverTime());
        for (IProductComponent target : targets) {
            ProductAssociation.invokeMethod(this.addMethod, relevantSource, target);
        }
        return source;
    }

    public <S extends IProductComponent> S addTargetObjects(S source, Calendar effectiveDate, IProductComponent ... targets) {
        return this.addTargetObjects(source, effectiveDate, Arrays.asList(targets));
    }

    public <S extends IProductComponent> S addTargetObject(S source, Calendar effectiveDate, IProductComponent target, CardinalityRange cardinality) {
        if (this.addMethodWithCardinality == null) {
            if (this.isOverriding()) {
                return this.getSuperAssociation().addTargetObject(source, effectiveDate, target, cardinality);
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = this.getName();
            objectArray[1] = source;
            Object object = objectArray[2] = this.isToOneAssociation() ? "setting" : "adding";
            objectArray[3] = this.isDerivedUnion() ? " because it is a derived union" : (this.isMatchingAssociationPresent() ? " because it has no matching association" : "; make sure a method annotated with @" + IpsAssociationAdder.class.getSimpleName() + "(withCardinality = true) exists");
            throw new IllegalArgumentException(String.format("The association %s on source object %s does not allow %s target objects with cardinality%s.", objectArray));
        }
        Object relevantSource = ProductAssociation.getRelevantProductObject(source, effectiveDate, this.isChangingOverTime());
        ProductAssociation.invokeMethod(this.addMethodWithCardinality, relevantSource, new Object[]{target, cardinality});
        return source;
    }

    public <S extends IProductComponent> S removeTargetObjects(S source, Calendar effectiveDate, List<IProductComponent> targetsToRemove) {
        if (this.isToOneAssociation()) {
            if (targetsToRemove.size() > 1) {
                throw new IllegalArgumentException(String.format("The association %s on source object %s allows a maxmimum of one target object but %s were tried to remove.", this.getName(), source, targetsToRemove.size()));
            }
            if (targetsToRemove.size() == 1) {
                this.resetTargetObject(source, effectiveDate, targetsToRemove.get(0));
            }
        } else {
            if (this.removeMethod == null) {
                if (this.isOverriding()) {
                    return this.getSuperAssociation().removeTargetObjects(source, effectiveDate, targetsToRemove);
                }
                throw new IllegalArgumentException(String.format("The association %s on source object %s does not allow removing target objects%s.", this.getName(), source, this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationRemover.class.getSimpleName() + " exists"));
            }
            Object relevantSource = ProductAssociation.getRelevantProductObject(source, effectiveDate, this.isChangingOverTime());
            for (IProductComponent targetToRemove : targetsToRemove) {
                ProductAssociation.invokeMethod(this.removeMethod, relevantSource, targetToRemove);
            }
        }
        return source;
    }

    public <S extends IProductComponent> S removeTargetObjects(S source, Calendar effectiveDate, IProductComponent ... targetsToRemove) {
        return this.removeTargetObjects(source, effectiveDate, Arrays.asList(targetsToRemove));
    }

    @Override
    public PolicyCmptType getMatchingAssociationSourceType() {
        return (PolicyCmptType)super.getMatchingAssociationSourceType();
    }

    @Override
    public PolicyAssociation getMatchingAssociation() {
        return (PolicyAssociation)super.getMatchingAssociation();
    }

    public Optional<PolicyAssociation> findMatchingAssociation() {
        return Optional.ofNullable(this.getMatchingAssociation());
    }

    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    public <T extends IProductComponent> Collection<IProductComponentLink<T>> getLinks(IProductComponent prodCmpt, Calendar effectiveDate) {
        if (this.isChangingOverTime()) {
            Object generation = ProductAssociation.getRelevantProductObject(prodCmpt, effectiveDate, true);
            return this.getLinksFromObject(generation);
        }
        return this.getLinksFromObject(prodCmpt);
    }

    @Override
    public ProductAssociation getSuperAssociation() {
        return (ProductAssociation)super.getSuperAssociation();
    }

    private <S extends IProductComponent> void resetTargetObject(S source, Calendar effectiveDate, IProductComponent targetToReset) {
        if (this.getTargetObjects(source, effectiveDate).contains(targetToReset)) {
            this.addTargetObjects(source, effectiveDate, new IProductComponent[]{null});
        }
    }

    private <T extends IProductComponent> Collection<IProductComponentLink<T>> getLinksFromObject(Object prodCmptOrGeneration) {
        if (this.getLinksMethod == null) {
            if (this.isOverriding()) {
                return this.getSuperAssociation().getLinksFromObject(prodCmptOrGeneration);
            }
            throw new IllegalArgumentException(String.format("The association %s on %s does not allow retrieving links%s.", this.getName(), prodCmptOrGeneration, this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationLinks.class + " exists"));
        }
        if (this.isToOneAssociation()) {
            IProductComponentLink link = (IProductComponentLink)ProductAssociation.invokeMethod(this.getLinksMethod, prodCmptOrGeneration, new Object[0]);
            if (link == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(link);
        }
        return (Collection)ProductAssociation.invokeMethod(this.getLinksMethod, prodCmptOrGeneration, new Object[0]);
    }
}

